/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.jpos.jniscanner;

import com.zebra.jpos.jniscanner.ArgStruct;
import com.zebra.jpos.jniscanner.EvtStruct;
import com.zebra.jpos.jniscanner.GetScannerArgStruct;
import com.zebra.jpos.jniscanner.ICSEvents;
import com.zebra.jpos.jniscanner.OpenArgStruct;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JCoreScanner {
    public static ArrayList<ICSEvents> csevents;
    public static int UNSUBSCRIBE_ALL;
    public static int SUBSCRIBE_BARCODE;
    public static int SUBSCRIBE_IMAGE;
    public static int SUBSCRIBE_VIDEO;
    public static int SUBSCRIBE_RMD;
    public static int SUBSCRIBE_PNP;
    public static int SUBSCRIBE_CMD_RESPONSE;
    public static int SUBSCRIBE_DIO;
    public static int SUBSCRIBE_NOTIFICATION;
    public static JCoreScanner jcoreScanner;
    public static boolean isRegistered;
    public static boolean isWndowsSystem;

    public native void Initiate();

    public native int GetScanners(GetScannerArgStruct var1);

    public native int Open(OpenArgStruct var1);

    public native int Close(ArgStruct var1);

    public native int ExecCommand(ArgStruct var1);

    public native int ExecCommandAsync(ArgStruct var1);

    public native void readEvents(EvtStruct var1);

    public native void readPNPEvents(EvtStruct var1);

    public native void readNotificationEvents(EvtStruct var1);

    public native void readRMDEvents(EvtStruct var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void EventCallback(int n, String string) {
        JCoreScanner jCoreScanner = this;
        synchronized (jCoreScanner) {
            for (ICSEvents iCSEvents : csevents) {
                try {
                    iCSEvents.onDecodeDataEvent(n, string);
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    Logger.getLogger(JCoreScanner.class.getName()).log(Level.SEVERE, null, interruptedException);
                }
            }
        }
    }

    public void PnpEventCallback(int n, String string) {
        for (ICSEvents iCSEvents : csevents) {
            iCSEvents.onPnpEvent(n, string);
        }
    }

    public void NotificationEventCallback(int n, String string) {
        for (ICSEvents iCSEvents : csevents) {
            iCSEvents.OnScannerNotificationEvent(n, string);
        }
    }

    public void RmdEventCallback(int n, String string) {
        for (ICSEvents iCSEvents : csevents) {
            iCSEvents.onScannerRMDEvent(n, string);
        }
    }

    static {
        UNSUBSCRIBE_ALL = 0;
        SUBSCRIBE_BARCODE = 1;
        SUBSCRIBE_IMAGE = 2;
        SUBSCRIBE_VIDEO = 4;
        SUBSCRIBE_RMD = 8;
        SUBSCRIBE_PNP = 16;
        SUBSCRIBE_CMD_RESPONSE = 32;
        SUBSCRIBE_DIO = 64;
        SUBSCRIBE_NOTIFICATION = 128;
        jcoreScanner = null;
        isRegistered = false;
        isWndowsSystem = false;
        String string = System.getProperty("os.name");
        if (string.toLowerCase().startsWith("win")) {
            if (System.getProperty("os.arch").equalsIgnoreCase("x86")) {
                System.loadLibrary("CSJPOSScanner");
            } else {
                System.loadLibrary("CSJPOSScanner64");
            }
            isWndowsSystem = true;
        } else {
            System.loadLibrary("cs-jniscanner");
            isWndowsSystem = false;
        }
        if (jcoreScanner == null) {
            jcoreScanner = new JCoreScanner();
        }
        if (csevents == null) {
            csevents = new ArrayList();
        }
    }
}

