/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.jpos.jniscanner;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.imageio.stream.MemoryCacheImageInputStream;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public final class Picture2
implements ActionListener {
    private BufferedImage image;
    private JFrame frame;
    private String filename;
    private boolean isOriginUpperLeft = true;
    private int width;
    private int height;

    public Picture2(int n, int n2) {
        this.width = n;
        this.height = n2;
        this.image = new BufferedImage(n, n2, 1);
        this.filename = n + "-by-" + n2;
    }

    public Picture2(String string) {
        this.filename = string;
        try {
            File file = new File(string);
            if (file.isFile()) {
                this.image = ImageIO.read(file);
            } else {
                URL uRL = this.getClass().getResource(string);
                if (uRL == null) {
                    uRL = new URL(string);
                }
                this.image = ImageIO.read(uRL);
            }
            this.width = this.image.getWidth(null);
            this.height = this.image.getHeight(null);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Could not open file: " + string);
        }
    }

    public Picture2(MemoryCacheImageInputStream memoryCacheImageInputStream) {
        try {
            if (memoryCacheImageInputStream != null) {
                BufferedImage bufferedImage = ImageIO.read(memoryCacheImageInputStream);
                this.image = this.createResizedCopy(bufferedImage, 400, 300, true);
            }
            this.width = this.image.getWidth(null);
            this.height = this.image.getHeight(null);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Could not open file: " + this.filename);
        }
    }

    public Picture2(File file) {
        try {
            this.image = ImageIO.read(file);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Could not open file: " + file);
        }
        if (this.image == null) {
            throw new RuntimeException("Invalid image file: " + file);
        }
    }

    BufferedImage createResizedCopy(Image image, int n, int n2, boolean bl) {
        System.out.println("resizing...");
        int n3 = bl ? 1 : 2;
        BufferedImage bufferedImage = new BufferedImage(n, n2, n3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        if (bl) {
            graphics2D.setComposite(AlphaComposite.Src);
        }
        graphics2D.drawImage(image, 0, 0, n, n2, null);
        graphics2D.dispose();
        return bufferedImage;
    }

    public JLabel getJLabel() {
        if (this.image == null) {
            return null;
        }
        ImageIcon imageIcon = new ImageIcon(this.image);
        return new JLabel(imageIcon);
    }

    public void setOriginUpperLeft() {
        this.isOriginUpperLeft = true;
    }

    public void setOriginLowerLeft() {
        this.isOriginUpperLeft = false;
    }

    public void show() {
        if (this.frame == null) {
            this.frame = new JFrame();
            JMenuBar jMenuBar = new JMenuBar();
            JMenu jMenu = new JMenu("File");
            jMenuBar.add(jMenu);
            JMenuItem jMenuItem = new JMenuItem(" Save...   ");
            jMenuItem.addActionListener(this);
            jMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            jMenu.add(jMenuItem);
            this.frame.setJMenuBar(jMenuBar);
            this.frame.setContentPane(this.getJLabel());
            this.frame.setDefaultCloseOperation(2);
            this.frame.setTitle(this.filename);
            this.frame.setResizable(false);
            this.frame.pack();
            this.frame.setVisible(true);
        }
        this.frame.repaint();
    }

    public int height() {
        return this.height;
    }

    public int width() {
        return this.width;
    }

    public Color get(int n, int n2) {
        if (this.isOriginUpperLeft) {
            return new Color(this.image.getRGB(n, n2));
        }
        return new Color(this.image.getRGB(n, this.height - n2 - 1));
    }

    public void set(int n, int n2, Color color) {
        if (color == null) {
            throw new RuntimeException("can't set Color to null");
        }
        if (this.isOriginUpperLeft) {
            this.image.setRGB(n, n2, color.getRGB());
        } else {
            this.image.setRGB(n, this.height - n2 - 1, color.getRGB());
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        Picture2 picture2 = (Picture2)object;
        if (this.width() != picture2.width()) {
            return false;
        }
        if (this.height() != picture2.height()) {
            return false;
        }
        for (int i = 0; i < this.width(); ++i) {
            for (int j = 0; j < this.height(); ++j) {
                if (this.get(i, j).equals(picture2.get(i, j))) continue;
                return false;
            }
        }
        return true;
    }

    public void save(String string) {
        this.save(new File(string));
    }

    public void save(File file) {
        this.filename = file.getName();
        if (this.frame != null) {
            this.frame.setTitle(this.filename);
        }
        String string = this.filename.substring(this.filename.lastIndexOf(46) + 1);
        if ((string = string.toLowerCase()).equals("jpg") || string.equals("png")) {
            try {
                ImageIO.write((RenderedImage)this.image, string, file);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        FileDialog fileDialog = new FileDialog((Frame)this.frame, "Use a .png or .jpg extension", 1);
        fileDialog.setVisible(true);
        if (fileDialog.getFile() != null) {
            this.save(fileDialog.getDirectory() + File.separator + fileDialog.getFile());
        }
    }

    public static void main(String[] stringArray) {
        Picture2 picture2 = new Picture2(stringArray[0]);
        picture2.show();
    }
}

