/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.behaviors.interpolators;

import com.sun.j3d.internal.J3dUtilsI18N;
import com.sun.j3d.utils.behaviors.interpolators.CubicSplineSegment;
import com.sun.j3d.utils.behaviors.interpolators.TCBKeyFrame;

public class CubicSplineCurve {
    private float totalCurveLength;
    private CubicSplineSegment[] cubicSplineSegment;
    public int numSegments;

    CubicSplineCurve() {
        this.numSegments = 0;
        this.totalCurveLength = 0.0f;
    }

    CubicSplineCurve(TCBKeyFrame[] tCBKeyFrameArray) {
        int n = tCBKeyFrameArray.length;
        if (n < 4) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("CubicSplineCurve0"));
        }
        this.numSegments = n - 3;
        this.cubicSplineSegment = new CubicSplineSegment[this.numSegments];
        int n2 = 0;
        int n3 = 1;
        int n4 = 2;
        int n5 = 3;
        while (n2 < this.numSegments) {
            this.cubicSplineSegment[n2] = new CubicSplineSegment(tCBKeyFrameArray[n2], tCBKeyFrameArray[n3], tCBKeyFrameArray[n4], tCBKeyFrameArray[n5]);
            ++n2;
            ++n3;
            ++n4;
            ++n5;
        }
        this.computeTotalCurveLength();
    }

    CubicSplineCurve(CubicSplineSegment[] cubicSplineSegmentArray) {
        this.cubicSplineSegment = new CubicSplineSegment[cubicSplineSegmentArray.length];
        this.numSegments = this.cubicSplineSegment.length;
        int n = 0;
        while (n < this.numSegments) {
            this.cubicSplineSegment[n] = cubicSplineSegmentArray[n];
            ++n;
        }
        this.computeTotalCurveLength();
    }

    public void setSegments(CubicSplineSegment[] cubicSplineSegmentArray) {
        this.cubicSplineSegment = new CubicSplineSegment[cubicSplineSegmentArray.length];
        this.numSegments = this.cubicSplineSegment.length;
        int n = 0;
        while (n < this.numSegments) {
            this.cubicSplineSegment[n] = cubicSplineSegmentArray[n];
            ++n;
        }
        this.computeTotalCurveLength();
    }

    public CubicSplineSegment getSegment(int n) {
        return this.cubicSplineSegment[n];
    }

    private void computeTotalCurveLength() {
        this.totalCurveLength = 0.0f;
        int n = 0;
        while (n < this.numSegments) {
            this.totalCurveLength += this.cubicSplineSegment[n].length;
            ++n;
        }
    }

    public float getTotalCurveLength() {
        return this.totalCurveLength;
    }
}

