/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d;

import com.sun.j3d.utils.scenegraph.io.retained.Controller;
import com.sun.j3d.utils.scenegraph.io.retained.SymbolTableData;
import com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d.LeafState;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.media.j3d.Appearance;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.Morph;
import javax.media.j3d.SceneGraphObject;

public class MorphState
extends LeafState {
    private int[] geometry;
    private double[] weights;
    private int appearance;

    public MorphState(SymbolTableData symbolTableData, Controller controller) {
        super(symbolTableData, controller);
        if (this.node != null) {
            this.appearance = controller.getSymbolTable().addReference((SceneGraphObject)((Morph)this.node).getAppearance());
            this.weights = ((Morph)this.node).getWeights();
            this.geometry = new int[this.weights.length];
            int n = 0;
            while (n < this.weights.length) {
                this.geometry[n] = controller.getSymbolTable().addReference((SceneGraphObject)((Morph)this.node).getGeometryArray(n));
                ++n;
            }
        }
    }

    public void writeObject(DataOutput dataOutput) throws IOException {
        super.writeObject(dataOutput);
        this.control.writeBounds(dataOutput, ((Morph)this.node).getCollisionBounds());
        dataOutput.writeInt(this.appearance);
        dataOutput.writeBoolean(((Morph)this.node).getAppearanceOverrideEnable());
        dataOutput.writeInt(this.geometry.length);
        int n = 0;
        while (n < this.geometry.length) {
            dataOutput.writeInt(this.geometry[n]);
            dataOutput.writeDouble(this.weights[n]);
            ++n;
        }
    }

    public void readObject(DataInput dataInput) throws IOException {
        super.readObject(dataInput);
        ((Morph)this.node).setCollisionBounds(this.control.readBounds(dataInput));
        this.appearance = dataInput.readInt();
        ((Morph)this.node).setAppearanceOverrideEnable(dataInput.readBoolean());
        int n = dataInput.readInt();
        this.geometry = new int[n];
        this.weights = new double[n];
        int n2 = 0;
        while (n2 < this.geometry.length) {
            this.geometry[n2] = dataInput.readInt();
            this.weights[n2] = dataInput.readDouble();
            ++n2;
        }
    }

    public void addSubReference() {
        this.control.getSymbolTable().incNodeComponentRefCount(this.appearance);
        int n = 0;
        while (n < this.geometry.length) {
            this.control.getSymbolTable().incNodeComponentRefCount(this.geometry[n]);
            ++n;
        }
    }

    public void buildGraph() {
        ((Morph)this.node).setAppearance((Appearance)this.control.getSymbolTable().getJ3dNode(this.appearance));
        GeometryArray[] geometryArrayArray = new GeometryArray[this.geometry.length];
        int n = 0;
        while (n < this.geometry.length) {
            geometryArrayArray[n] = (GeometryArray)this.control.getSymbolTable().getJ3dNode(this.geometry[n]);
            ++n;
        }
        ((Morph)this.node).setGeometryArrays(geometryArrayArray);
        ((Morph)this.node).setWeights(this.weights);
        super.buildGraph();
    }

    protected SceneGraphObject createNode() {
        return new Morph(null);
    }
}

