/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d;

import com.sun.j3d.utils.scenegraph.io.SceneGraphIO;
import com.sun.j3d.utils.scenegraph.io.retained.Controller;
import com.sun.j3d.utils.scenegraph.io.retained.SGIORuntimeException;
import com.sun.j3d.utils.scenegraph.io.retained.SymbolTableData;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import javax.media.j3d.SceneGraphObject;

public abstract class SceneGraphObjectState {
    protected SceneGraphObject node;
    protected SymbolTableData symbol;
    protected Controller control;
    protected String nodeClassName;

    public SceneGraphObjectState(SymbolTableData symbolTableData, Controller controller) {
        this.symbol = symbolTableData;
        this.control = controller;
        if (symbolTableData != null) {
            this.node = symbolTableData.j3dNode;
        }
        if (this.node != null) {
            this.nodeClassName = this.node.getClass().getName();
            try {
                if (this.node instanceof SceneGraphIO) {
                    ((SceneGraphIO)this.node).createSceneGraphObjectReferences(controller.getSymbolTable());
                }
            }
            catch (Exception exception) {
                System.err.println("Exception in createSceneGraphObjectReferences");
                exception.printStackTrace();
            }
        }
    }

    public void writeObject(DataOutput dataOutput) throws IOException {
        boolean bl = this.node instanceof SceneGraphIO;
        dataOutput.writeBoolean(bl);
        dataOutput.writeInt(this.symbol.nodeID);
        int n = this.control.getNodeClassID(this.node);
        dataOutput.writeShort(n);
        if (n == -1) {
            dataOutput.writeUTF(this.nodeClassName);
        }
        this.writeConstructorParams(dataOutput);
        if (bl) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            ((SceneGraphIO)this.node).writeSceneGraphObject(dataOutputStream);
            dataOutputStream.close();
            dataOutput.writeInt(byteArrayOutputStream.size());
            dataOutput.write(byteArrayOutputStream.toByteArray());
        }
        this.writeUserData(dataOutput);
        this.writeCapabilities(dataOutput);
    }

    public void readObject(DataInput dataInput) throws IOException {
        boolean bl = dataInput.readBoolean();
        int n = dataInput.readInt();
        short s = dataInput.readShort();
        this.nodeClassName = null;
        if (s == -1) {
            this.nodeClassName = dataInput.readUTF();
        }
        this.readConstructorParams(dataInput);
        if (s != -1) {
            this.node = this.createNode();
            this.nodeClassName = this.node.getClass().getName();
        } else {
            this.node = this.createNode(this.nodeClassName);
        }
        if (bl) {
            if (this.control.getCurrentFileVersion() == 1) {
                ((SceneGraphIO)this.node).readSceneGraphObject(dataInput);
            } else {
                int n2 = dataInput.readInt();
                if (this.node instanceof SceneGraphIO) {
                    byte[] byArray = new byte[n2];
                    dataInput.readFully(byArray);
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                    DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                    ((SceneGraphIO)this.node).readSceneGraphObject(dataInputStream);
                    dataInputStream.close();
                } else {
                    dataInput.skipBytes(n2);
                }
            }
        }
        this.symbol = this.control.getSymbolTable().createSymbol(this, this.node, n);
        this.readUserData(dataInput);
        this.readCapabilities(dataInput);
    }

    public SceneGraphObject getNode() {
        return this.node;
    }

    public int getNodeID() {
        return this.symbol.nodeID;
    }

    public SymbolTableData getSymbol() {
        return this.symbol;
    }

    private void readUserData(DataInput dataInput) throws IOException {
        this.node.setUserData(this.control.readSerializedData(dataInput));
    }

    private void writeUserData(DataOutput dataOutput) throws IOException {
        Object object = this.node.getUserData();
        if (object != null && !(object instanceof Serializable)) {
            System.err.println("UserData is not Serializable and will not be saved");
            object = null;
        }
        this.control.writeSerializedData(dataOutput, (Serializable)object);
    }

    private void writeCapabilities(DataOutput dataOutput) throws IOException {
        long l = 0L;
        long l2 = 0L;
        int n = 0;
        while (n < 64) {
            if (this.node.getCapability(n)) {
                l |= 1L << n;
            }
            if (!this.node.getCapabilityIsFrequent(n)) {
                l2 |= 1L << n;
            }
            ++n;
        }
        dataOutput.writeLong(l);
        dataOutput.writeLong(l2);
    }

    private void readCapabilities(DataInput dataInput) throws IOException {
        long l = dataInput.readLong();
        long l2 = dataInput.readLong();
        int n = 0;
        while (n < 64) {
            if ((l & 1L << n) != 0L) {
                this.node.setCapability(n);
            }
            if ((l2 & 1L << n) != 0L) {
                this.node.clearCapabilityIsFrequent(n);
            }
            ++n;
        }
    }

    protected void writeConstructorParams(DataOutput dataOutput) throws IOException {
    }

    protected void readConstructorParams(DataInput dataInput) throws IOException {
    }

    protected SceneGraphObject createNode() {
        throw new SGIORuntimeException("createNode() not implemented in class " + this.getClass().getName());
    }

    protected SceneGraphObject createNode(Class clazz) {
        SceneGraphObject sceneGraphObject;
        try {
            sceneGraphObject = (SceneGraphObject)clazz.newInstance();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SGIORuntimeException("Broken State class for " + clazz.getClass().getName() + " - IllegalAccess");
        }
        catch (InstantiationException instantiationException) {
            throw new SGIORuntimeException("Broken State class for " + clazz.getClass().getName());
        }
        return sceneGraphObject;
    }

    protected SceneGraphObject createNode(String string) {
        SceneGraphObject sceneGraphObject;
        try {
            Class<?> clazz = Class.forName(string, true, this.control.getClassLoader());
            sceneGraphObject = this.createNode(clazz);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (this.control.useSuperClassIfNoChildClass()) {
                sceneGraphObject = this.createNodeFromSuper(string);
            }
            throw new SGIORuntimeException("No Such Class " + string);
        }
        return sceneGraphObject;
    }

    private SceneGraphObject createNodeFromSuper(String string) {
        SceneGraphObject sceneGraphObject;
        String string2 = this.getClass().getName();
        String string3 = string2.substring(string2.indexOf("state") + 6, string2.length() - 5);
        System.err.println("Unable to create node " + string + " attempting Java3D superclass " + string3);
        try {
            Class<?> clazz = Class.forName(string3, true, this.control.getClassLoader());
            sceneGraphObject = (SceneGraphObject)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SGIORuntimeException("No Such Class " + string);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SGIORuntimeException("Broken State class for " + string + " - IllegalAccess");
        }
        catch (InstantiationException instantiationException) {
            throw new SGIORuntimeException("Unable to instantiate class " + string);
        }
        return sceneGraphObject;
    }

    /*
     * Unable to fully structure code
     */
    private SceneGraphObject createNode(String var1_1, Class[] var2_2, Object[] var3_3) {
        block8: {
            try {
                var6_4 = Class.forName(var1_1);
                var5_6 = var6_4.getConstructor(var2_2);
                var4_7 = (SceneGraphObject)var5_6.newInstance(var3_3);
                break block8;
            }
            catch (ClassNotFoundException var6_5) {
                if (this.control.useSuperClassIfNoChildClass()) {
                    var4_7 = this.createNodeFromSuper(var1_1, var2_2, var3_3);
                    break block8;
                }
                throw new SGIORuntimeException("No State class for " + var1_1);
            }
            catch (IllegalAccessException var7_8) {
                throw new SGIORuntimeException("Broken State class for " + var1_1 + " - IllegalAccess");
            }
            catch (InstantiationException var8_9) {
                throw new SGIORuntimeException("Broken State class for " + var1_1);
            }
            catch (InvocationTargetException var9_10) {
                throw new SGIORuntimeException("InvocationTargetException for " + var1_1);
            }
            catch (NoSuchMethodException var10_11) {
                var11_12 = 0;
                ** while (var11_12 < var2_2.length)
            }
lbl-1000:
            // 1 sources

            {
                System.err.println(var2_2[var11_12].getName());
                ++var11_12;
                continue;
            }
lbl23:
            // 1 sources

            System.err.println("------");
            throw new SGIORuntimeException("Invalid constructor for " + var1_1);
        }
        return var4_7;
    }

    /*
     * Unable to fully structure code
     */
    protected SceneGraphObject createNode(Class var1_1, Class[] var2_2, Object[] var3_3) {
        block6: {
            try {
                var5_4 = var1_1.getConstructor(var2_2);
                var4_5 = (SceneGraphObject)var5_4.newInstance(var3_3);
                break block6;
            }
            catch (IllegalAccessException var6_6) {
                throw new SGIORuntimeException("Broken State class for " + var1_1.getClass().getName() + " - IllegalAccess");
            }
            catch (InstantiationException var7_7) {
                throw new SGIORuntimeException("Broken State class for " + var1_1.getClass().getName());
            }
            catch (InvocationTargetException var8_8) {
                throw new SGIORuntimeException("InvocationTargetException for " + var1_1.getClass().getName());
            }
            catch (NoSuchMethodException var9_9) {
                var10_10 = 0;
                ** while (var10_10 < var2_2.length)
            }
lbl-1000:
            // 1 sources

            {
                System.err.println(var2_2[var10_10].getName());
                ++var10_10;
                continue;
            }
lbl17:
            // 1 sources

            System.err.println("------");
            throw new SGIORuntimeException("Invalid constructor for " + var1_1.getClass().getName());
        }
        return var4_5;
    }

    /*
     * Unable to fully structure code
     */
    private SceneGraphObject createNodeFromSuper(String var1_1, Class[] var2_2, Object[] var3_3) {
        block7: {
            var5_4 = this.getClass().getName();
            var6_5 = var5_4.substring(var5_4.indexOf("state") + 6, var5_4.length() - 5);
            try {
                var8_6 = Class.forName(var6_5);
                var7_8 = var8_6.getConstructor(var2_2);
                var4_9 = (SceneGraphObject)var7_8.newInstance(var3_3);
                break block7;
            }
            catch (ClassNotFoundException var8_7) {
                throw new SGIORuntimeException("No State class for " + var6_5);
            }
            catch (IllegalAccessException var9_10) {
                throw new SGIORuntimeException("Broken State class for " + var1_1 + " - IllegalAccess");
            }
            catch (InstantiationException var10_11) {
                throw new SGIORuntimeException("Broken State class for " + var1_1);
            }
            catch (InvocationTargetException var11_12) {
                throw new SGIORuntimeException("InvocationTargetException for " + var1_1);
            }
            catch (NoSuchMethodException var12_13) {
                var13_14 = 0;
                ** while (var13_14 < var2_2.length)
            }
lbl-1000:
            // 1 sources

            {
                System.err.println(var2_2[var13_14].getName());
                ++var13_14;
                continue;
            }
lbl22:
            // 1 sources

            System.err.println("------");
            throw new SGIORuntimeException("Invalid constructor for " + var1_1);
        }
        return var4_9;
    }

    protected SceneGraphObjectState createState(SceneGraphObject sceneGraphObject, Controller controller) {
        return controller.createState(sceneGraphObject);
    }

    private String getClassName(Class clazz) {
        return clazz.getName().substring(clazz.getName().lastIndexOf(46) + 1);
    }

    public void buildGraph() {
        if (this.node instanceof SceneGraphIO) {
            ((SceneGraphIO)this.node).restoreSceneGraphObjectReferences(this.control.getSymbolTable());
        }
    }

    public void cleanup() {
        this.control = null;
        this.node = null;
    }
}

