/*
 * Decompiled with CFR 0.152.
 */
package com.jujutsu.tsne;

import org.ejml.data.D1Matrix64F;
import org.ejml.data.DenseMatrix64F;
import org.ejml.data.Matrix64F;
import org.ejml.data.ReshapeMatrix64F;
import org.ejml.data.RowD1Matrix64F;
import org.ejml.factory.DecompositionFactory;
import org.ejml.interfaces.decomposition.SingularValueDecomposition;
import org.ejml.ops.CommonOps;
import org.ejml.ops.NormOps;
import org.ejml.ops.SingularOps;

public class PrincipalComponentAnalysis {
    private DenseMatrix64F V_t;
    private int numComponents;
    private DenseMatrix64F A = new DenseMatrix64F(1, 1);
    private int sampleIndex;
    double[] mean;

    public void setup(int numSamples, int sampleSize) {
        this.mean = new double[sampleSize];
        this.A.reshape(numSamples, sampleSize, false);
        this.sampleIndex = 0;
        this.numComponents = -1;
    }

    public void addSample(double[] sampleData) {
        if (this.A.getNumCols() != sampleData.length) {
            throw new IllegalArgumentException("Unexpected sample size");
        }
        if (this.sampleIndex >= this.A.getNumRows()) {
            throw new IllegalArgumentException("Too many samples");
        }
        int i = 0;
        while (i < sampleData.length) {
            this.A.set(this.sampleIndex, i, sampleData[i]);
            ++i;
        }
        ++this.sampleIndex;
    }

    public void computeBasis(int numComponents) {
        int j;
        if (numComponents > this.A.getNumCols()) {
            throw new IllegalArgumentException("More components requested that the data's length.");
        }
        if (this.sampleIndex != this.A.getNumRows()) {
            throw new IllegalArgumentException("Not all the data has been added");
        }
        if (numComponents > this.sampleIndex) {
            throw new IllegalArgumentException("More data needed to compute the desired number of components");
        }
        this.numComponents = numComponents;
        int i = 0;
        while (i < this.A.getNumRows()) {
            j = 0;
            while (j < this.mean.length) {
                int n = j;
                this.mean[n] = this.mean[n] + this.A.get(i, j);
                ++j;
            }
            ++i;
        }
        int j2 = 0;
        while (j2 < this.mean.length) {
            int n = j2++;
            this.mean[n] = this.mean[n] / (double)this.A.getNumRows();
        }
        i = 0;
        while (i < this.A.getNumRows()) {
            j = 0;
            while (j < this.mean.length) {
                this.A.set(i, j, this.A.get(i, j) - this.mean[j]);
                ++j;
            }
            ++i;
        }
        SingularValueDecomposition svd = DecompositionFactory.svd((int)this.A.numRows, (int)this.A.numCols, (boolean)false, (boolean)true, (boolean)false);
        if (!svd.decompose((Matrix64F)this.A)) {
            throw new RuntimeException("SVD failed");
        }
        this.V_t = (DenseMatrix64F)svd.getV(null, true);
        DenseMatrix64F W = (DenseMatrix64F)svd.getW(null);
        SingularOps.descendingOrder(null, (boolean)false, (DenseMatrix64F)W, (DenseMatrix64F)this.V_t, (boolean)true);
        this.V_t.reshape(numComponents, this.mean.length, true);
    }

    public double[] getBasisVector(int which) {
        if (which < 0 || which >= this.numComponents) {
            throw new IllegalArgumentException("Invalid component");
        }
        DenseMatrix64F v = new DenseMatrix64F(1, this.A.numCols);
        CommonOps.extract((ReshapeMatrix64F)this.V_t, (int)which, (int)(which + 1), (int)0, (int)this.A.numCols, (ReshapeMatrix64F)v, (int)0, (int)0);
        return v.data;
    }

    public double[] sampleToEigenSpace(double[] sampleData) {
        if (sampleData.length != this.A.getNumCols()) {
            throw new IllegalArgumentException("Unexpected sample length");
        }
        DenseMatrix64F mean = DenseMatrix64F.wrap((int)this.A.getNumCols(), (int)1, (double[])this.mean);
        DenseMatrix64F s = new DenseMatrix64F(this.A.getNumCols(), 1, true, sampleData);
        DenseMatrix64F r = new DenseMatrix64F(this.numComponents, 1);
        CommonOps.subtract((D1Matrix64F)s, (D1Matrix64F)mean, (D1Matrix64F)s);
        CommonOps.mult((RowD1Matrix64F)this.V_t, (RowD1Matrix64F)s, (RowD1Matrix64F)r);
        return r.data;
    }

    public double[] eigenToSampleSpace(double[] eigenData) {
        if (eigenData.length != this.numComponents) {
            throw new IllegalArgumentException("Unexpected sample length");
        }
        DenseMatrix64F s = new DenseMatrix64F(this.A.getNumCols(), 1);
        DenseMatrix64F r = DenseMatrix64F.wrap((int)this.numComponents, (int)1, (double[])eigenData);
        CommonOps.multTransA((RowD1Matrix64F)this.V_t, (RowD1Matrix64F)r, (RowD1Matrix64F)s);
        DenseMatrix64F mean = DenseMatrix64F.wrap((int)this.A.getNumCols(), (int)1, (double[])this.mean);
        CommonOps.add((D1Matrix64F)s, (D1Matrix64F)mean, (D1Matrix64F)s);
        return s.data;
    }

    public double errorMembership(double[] sampleA) {
        double[] eig = this.sampleToEigenSpace(sampleA);
        double[] reproj = this.eigenToSampleSpace(eig);
        double total = 0.0;
        int i = 0;
        while (i < reproj.length) {
            double d = sampleA[i] - reproj[i];
            total += d * d;
            ++i;
        }
        return Math.sqrt(total);
    }

    public double response(double[] sample) {
        if (sample.length != this.A.numCols) {
            throw new IllegalArgumentException("Expected input vector to be in sample space");
        }
        DenseMatrix64F dots = new DenseMatrix64F(this.numComponents, 1);
        DenseMatrix64F s = DenseMatrix64F.wrap((int)this.A.numCols, (int)1, (double[])sample);
        CommonOps.mult((RowD1Matrix64F)this.V_t, (RowD1Matrix64F)s, (RowD1Matrix64F)dots);
        return NormOps.normF((D1Matrix64F)dots);
    }

    public double[][] pca(double[][] matrix, int no_dims) {
        double[][] trafoed = new double[matrix.length][matrix[0].length];
        this.setup(matrix.length, matrix[0].length);
        int i = 0;
        while (i < matrix.length) {
            this.addSample(matrix[i]);
            ++i;
        }
        this.computeBasis(no_dims);
        i = 0;
        while (i < matrix.length) {
            trafoed[i] = this.sampleToEigenSpace(matrix[i]);
            int j = 0;
            while (j < trafoed[i].length) {
                double[] dArray = trafoed[i];
                int n = j++;
                dArray[n] = dArray[n] * -1.0;
            }
            ++i;
        }
        return trafoed;
    }
}

