/*
 * Decompiled with CFR 0.152.
 */
package com.jujutsu.tsne.barneshut;

import com.jujutsu.tsne.PrincipalComponentAnalysis;
import com.jujutsu.tsne.barneshut.BarnesHutTSne;
import com.jujutsu.tsne.barneshut.DataPoint;
import com.jujutsu.tsne.barneshut.Distance;
import com.jujutsu.tsne.barneshut.EuclideanDistance;
import com.jujutsu.tsne.barneshut.SPTree;
import com.jujutsu.tsne.barneshut.TSneConfiguration;
import com.jujutsu.tsne.barneshut.VpTree;
import com.jujutsu.utils.MatrixOps;
import java.util.ArrayList;
import java.util.concurrent.ThreadLocalRandom;

public class BHTSne
implements BarnesHutTSne {
    protected final Distance distance = new EuclideanDistance();
    protected volatile boolean abort = false;

    @Override
    public double[][] tsne(TSneConfiguration config) {
        return this.run(config);
    }

    private double[] flatten(double[][] x) {
        int noCols = x[0].length;
        double[] flat = new double[x.length * x[0].length];
        int i = 0;
        while (i < x.length) {
            int j = 0;
            while (j < x[i].length) {
                flat[i * noCols + j] = x[i][j];
                ++j;
            }
            ++i;
        }
        return flat;
    }

    private double[][] expand(double[] x, int N, int D) {
        double[][] expanded = new double[N][D];
        int row = 0;
        while (row < N) {
            int col = 0;
            while (col < D) {
                expanded[row][col] = x[row * D + col];
                ++col;
            }
            ++row;
        }
        return expanded;
    }

    static double sign_tsne(double x) {
        return x == 0.0 ? 0.0 : (x < 0.0 ? -1.0 : 1.0);
    }

    double[][] run(TSneConfiguration parameterObject) {
        int i;
        int i2;
        double sum_P;
        boolean exact;
        int D = parameterObject.getXStartDim();
        double[][] Xin = parameterObject.getXin();
        boolean bl = exact = parameterObject.getTheta() == 0.0;
        if (exact) {
            throw new IllegalArgumentException("The Barnes Hut implementation does not support exact inference yet (theta==0.0), if you want exact t-SNE please use one of the standard t-SNE implementations (FastTSne for instance)");
        }
        if (parameterObject.usePca() && D > parameterObject.getInitialDims() && parameterObject.getInitialDims() > 0) {
            PrincipalComponentAnalysis pca = new PrincipalComponentAnalysis();
            Xin = pca.pca(Xin, parameterObject.getInitialDims());
            D = parameterObject.getInitialDims();
            System.out.println("X:Shape after PCA is = " + Xin.length + " x " + Xin[0].length);
        }
        double[] X = this.flatten(Xin);
        int N = parameterObject.getNrRows();
        int no_dims = parameterObject.getOutputDims();
        double[] Y = new double[N * no_dims];
        System.out.println("X:Shape is = " + N + " x " + D);
        double perplexity = parameterObject.getPerplexity();
        if ((double)(N - 1) < 3.0 * perplexity) {
            throw new IllegalArgumentException("Perplexity too large for the number of data points!\n");
        }
        System.out.printf("Using no_dims = %d, perplexity = %f, and theta = %f\n", no_dims, perplexity, parameterObject.getTheta());
        double total_time = 0.0;
        int stop_lying_iter = 250;
        int mom_switch_iter = 250;
        double momentum = 0.5;
        double final_momentum = 0.8;
        double eta = 200.0;
        double[] dY = new double[N * no_dims];
        double[] uY = new double[N * no_dims];
        double[] gains = new double[N * no_dims];
        int i3 = 0;
        while (i3 < N * no_dims) {
            gains[i3] = 1.0;
            ++i3;
        }
        System.out.println("Computing input similarities...");
        long start = System.currentTimeMillis();
        double max_X = 0.0;
        int i4 = 0;
        while (i4 < N * D) {
            if (X[i4] > max_X) {
                max_X = X[i4];
            }
            ++i4;
        }
        i4 = 0;
        while (i4 < N * D) {
            int n = i4++;
            X[n] = X[n] / max_X;
        }
        double[] P = null;
        int K = (int)(3.0 * perplexity);
        int[] row_P = new int[N + 1];
        int[] col_P = new int[N * K];
        double[] val_P = new double[N * K];
        if (exact) {
            P = new double[N * N];
            this.computeGaussianPerplexity(X, N, D, P, perplexity);
            System.out.println("Symmetrizing...");
            int nN = 0;
            int n = 0;
            while (n < N) {
                int mN = 0;
                int m = n + 1;
                while (m < N) {
                    int n2 = nN + m;
                    P[n2] = P[n2] + P[mN + n];
                    P[mN + n] = P[nN + m];
                    mN += N;
                    ++m;
                }
                nN += N;
                ++n;
            }
            sum_P = 0.0;
            i2 = 0;
            while (i2 < N * N) {
                sum_P += P[i2];
                ++i2;
            }
            i2 = 0;
            while (i2 < N * N) {
                int n3 = i2++;
                P[n3] = P[n3] / sum_P;
            }
        } else {
            this.computeGaussianPerplexity(X, N, D, row_P, col_P, val_P, perplexity, K);
            SymResult res = this.symmetrizeMatrix(row_P, col_P, val_P, N);
            row_P = res.sym_row_P;
            col_P = res.sym_col_P;
            val_P = res.sym_val_P;
            sum_P = 0.0;
            i2 = 0;
            while (i2 < row_P[N]) {
                sum_P += val_P[i2];
                ++i2;
            }
            i2 = 0;
            while (i2 < row_P[N]) {
                int n = i2++;
                val_P[n] = val_P[n] / sum_P;
            }
        }
        long end = System.currentTimeMillis();
        if (exact) {
            i = 0;
            while (i < N * N) {
                int n = i++;
                P[n] = P[n] * 12.0;
            }
        } else {
            i = 0;
            while (i < row_P[N]) {
                int n = i++;
                val_P[n] = val_P[n] * 12.0;
            }
        }
        i = 0;
        while (i < N * no_dims) {
            Y[i] = ThreadLocalRandom.current().nextDouble() * 1.0E-4;
            ++i;
        }
        if (exact) {
            System.out.printf("Done in %4.2f seconds!\nLearning embedding...\n", (double)(end - start) / 1000.0);
        } else {
            System.out.printf("Done in %4.2f seconds (sparsity = %f)!\nLearning embedding...\n", (double)(end - start) / 1000.0, (double)row_P[N] / ((double)N * (double)N));
        }
        start = System.currentTimeMillis();
        int iter = 0;
        while (iter < parameterObject.getMaxIter() && !this.abort) {
            if (exact) {
                this.computeExactGradient(P, Y, N, no_dims, dY);
            } else {
                this.computeGradient(P, row_P, col_P, val_P, Y, N, no_dims, dY, parameterObject.getTheta());
            }
            this.updateGradient(N, no_dims, Y, momentum, eta, dY, uY, gains);
            this.zeroMean(Y, N, no_dims);
            if (iter == stop_lying_iter) {
                if (exact) {
                    int i5 = 0;
                    while (i5 < N * N) {
                        int n = i5++;
                        P[n] = P[n] / 12.0;
                    }
                } else {
                    int i6 = 0;
                    while (i6 < row_P[N]) {
                        int n = i6++;
                        val_P[n] = val_P[n] / 12.0;
                    }
                }
            }
            if (iter == mom_switch_iter) {
                momentum = final_momentum;
            }
            if ((iter > 0 && iter % 50 == 0 || iter == parameterObject.getMaxIter() - 1) && !parameterObject.silent()) {
                end = System.currentTimeMillis();
                String err_string = "not_calculated";
                if (parameterObject.printError()) {
                    double C = 0.0;
                    C = exact ? this.evaluateError(P, Y, N, no_dims) : this.evaluateError(row_P, col_P, val_P, Y, N, no_dims, parameterObject.getTheta());
                    err_string = "" + C;
                }
                if (iter == 0) {
                    System.out.printf("Iteration %d: error is %s\n", iter + 1, err_string);
                } else {
                    total_time += (double)(end - start) / 1000.0;
                    System.out.printf("Iteration %d: error is %s (50 iterations in %4.2f seconds)\n", iter, err_string, (double)(end - start) / 1000.0);
                }
                start = System.currentTimeMillis();
            }
            ++iter;
        }
        end = System.currentTimeMillis();
        System.out.printf("Fitting performed in %4.2f seconds.\n", total_time += (double)(end - start) / 1000.0);
        return this.expand(Y, N, no_dims);
    }

    void updateGradient(int N, int no_dims, double[] Y, double momentum, double eta, double[] dY, double[] uY, double[] gains) {
        int i = 0;
        while (i < N * no_dims) {
            double d = gains[i] = BHTSne.sign_tsne(dY[i]) != BHTSne.sign_tsne(uY[i]) ? gains[i] + 0.2 : gains[i] * 0.8;
            if (gains[i] < 0.01) {
                gains[i] = 0.01;
            }
            Y[i] = Y[i] + uY[i];
            uY[i] = momentum * uY[i] - eta * gains[i] * dY[i];
            ++i;
        }
    }

    void computeGradient(double[] P, int[] inp_row_P, int[] inp_col_P, double[] inp_val_P, double[] Y, int N, int D, double[] dC, double theta) {
        SPTree tree = new SPTree(D, Y, N);
        double[] sum_Q = new double[1];
        double[] pos_f = new double[N * D];
        double[][] neg_f = new double[N][D];
        tree.computeEdgeForces(inp_row_P, inp_col_P, inp_val_P, N, pos_f);
        int n = 0;
        while (n < N) {
            tree.computeNonEdgeForces(n, theta, neg_f[n], sum_Q);
            ++n;
        }
        n = 0;
        while (n < N) {
            int d = 0;
            while (d < D) {
                dC[n * D + d] = pos_f[n * D + d] - neg_f[n][d] / sum_Q[0];
                ++d;
            }
            ++n;
        }
    }

    void computeExactGradient(double[] P, double[] Y, int N, int D, double[] dC) {
        int i = 0;
        while (i < N * D) {
            dC[i] = 0.0;
            ++i;
        }
        double[] DD = new double[N * N];
        this.computeSquaredEuclideanDistance(Y, N, D, DD);
        double[] Q = new double[N * N];
        double sum_Q = 0.0;
        int nN = 0;
        int n = 0;
        while (n < N) {
            int m = 0;
            while (m < N) {
                if (n != m) {
                    Q[nN + m] = 1.0 / (1.0 + DD[nN + m]);
                    sum_Q += Q[nN + m];
                }
                ++m;
            }
            nN += N;
            ++n;
        }
        nN = 0;
        int nD = 0;
        int n2 = 0;
        while (n2 < N) {
            int mD = 0;
            int m = 0;
            while (m < N) {
                if (n2 != m) {
                    double mult = (P[nN + m] - Q[nN + m] / sum_Q) * Q[nN + m];
                    int d = 0;
                    while (d < D) {
                        int n3 = nD + d;
                        dC[n3] = dC[n3] + (Y[nD + d] - Y[mD + d]) * mult;
                        ++d;
                    }
                }
                mD += D;
                ++m;
            }
            nN += N;
            nD += D;
            ++n2;
        }
    }

    double evaluateError(double[] P, double[] Y, int N, int D) {
        double[] DD = new double[N * N];
        double[] Q = new double[N * N];
        this.computeSquaredEuclideanDistance(Y, N, D, DD);
        int nN = 0;
        double sum_Q = Double.MIN_VALUE;
        int n = 0;
        while (n < N) {
            int m = 0;
            while (m < N) {
                if (n != m) {
                    Q[nN + m] = 1.0 / (1.0 + DD[nN + m]);
                    sum_Q += Q[nN + m];
                } else {
                    Q[nN + m] = Double.MIN_VALUE;
                }
                ++m;
            }
            nN += N;
            ++n;
        }
        int i = 0;
        while (i < N * N) {
            int n2 = i++;
            Q[n2] = Q[n2] / sum_Q;
        }
        double C = 0.0;
        int n3 = 0;
        while (n3 < N * N) {
            C += P[n3] * Math.log((P[n3] + Double.MIN_VALUE) / (Q[n3] + Double.MIN_VALUE));
            ++n3;
        }
        return C;
    }

    double evaluateError(int[] row_P, int[] col_P, double[] val_P, double[] Y, int N, int D, double theta) {
        SPTree tree = new SPTree(D, Y, N);
        double[] buff = new double[D];
        double[] sum_Q = new double[1];
        int n = 0;
        while (n < N) {
            tree.computeNonEdgeForces(n, theta, buff, sum_Q);
            ++n;
        }
        double C = 0.0;
        int n2 = 0;
        while (n2 < N) {
            int ind1 = n2 * D;
            int i = row_P[n2];
            while (i < row_P[n2 + 1]) {
                double Q = 0.0;
                int ind2 = col_P[i] * D;
                int d = 0;
                while (d < D) {
                    buff[d] = Y[ind1 + d];
                    ++d;
                }
                d = 0;
                while (d < D) {
                    int n3 = d;
                    buff[n3] = buff[n3] - Y[ind2 + d];
                    ++d;
                }
                d = 0;
                while (d < D) {
                    Q += buff[d] * buff[d];
                    ++d;
                }
                Q = 1.0 / (1.0 + Q) / sum_Q[0];
                C += val_P[i] * Math.log((val_P[i] + Double.MIN_VALUE) / (Q + Double.MIN_VALUE));
                ++i;
            }
            ++n2;
        }
        return C;
    }

    void computeGaussianPerplexity(double[] X, int N, int D, double[] P, double perplexity) {
        double[] DD = new double[N * N];
        this.computeSquaredEuclideanDistance(X, N, D, DD);
        int nN = 0;
        int n = 0;
        while (n < N) {
            boolean found = false;
            double beta = 1.0;
            double min_beta = -1.7976931348623157E308;
            double max_beta = Double.MAX_VALUE;
            double tol = 1.0E-5;
            double sum_P = Double.MIN_VALUE;
            int iter = 0;
            while (!found && iter < 200) {
                int m = 0;
                while (m < N) {
                    P[nN + m] = Math.exp(-beta * DD[nN + m]);
                    ++m;
                }
                P[nN + n] = Double.MIN_VALUE;
                sum_P = Double.MIN_VALUE;
                m = 0;
                while (m < N) {
                    sum_P += P[nN + m];
                    ++m;
                }
                double H = 0.0;
                int m2 = 0;
                while (m2 < N) {
                    H += beta * (DD[nN + m2] * P[nN + m2]);
                    ++m2;
                }
                double Hdiff = (H = H / sum_P + Math.log(sum_P)) - Math.log(perplexity);
                if (Hdiff < tol && -Hdiff < tol) {
                    found = true;
                } else if (Hdiff > 0.0) {
                    min_beta = beta;
                    beta = max_beta == Double.MAX_VALUE || max_beta == -1.7976931348623157E308 ? (beta *= 2.0) : (beta + max_beta) / 2.0;
                } else {
                    max_beta = beta;
                    beta = min_beta == -1.7976931348623157E308 || min_beta == Double.MAX_VALUE ? (beta /= 2.0) : (beta + min_beta) / 2.0;
                }
                ++iter;
            }
            int m = 0;
            while (m < N) {
                int n2 = nN + m;
                P[n2] = P[n2] / sum_P;
                ++m;
            }
            nN += N;
            ++n;
        }
    }

    void computeGaussianPerplexity(double[] X, int N, int D, int[] _row_P, int[] _col_P, double[] _val_P, double perplexity, int K) {
        if (perplexity > (double)K) {
            System.out.println("Perplexity should be lower than K!");
        }
        int[] row_P = _row_P;
        int[] col_P = _col_P;
        double[] val_P = _val_P;
        double[] cur_P = new double[N - 1];
        row_P[0] = 0;
        int n = 0;
        while (n < N) {
            row_P[n + 1] = row_P[n] + K;
            ++n;
        }
        VpTree tree = new VpTree(this.distance);
        DataPoint[] obj_X = new DataPoint[N];
        int n2 = 0;
        while (n2 < N) {
            double[] row = MatrixOps.extractRowFromFlatMatrix(X, n2, D);
            obj_X[n2] = new DataPoint(D, n2, row);
            ++n2;
        }
        tree.create(obj_X);
        System.out.println("Building tree...");
        ArrayList<DataPoint> indices = new ArrayList<DataPoint>();
        ArrayList<Double> distances = new ArrayList<Double>();
        int n3 = 0;
        while (n3 < N) {
            if (n3 % 10000 == 0) {
                System.out.printf(" - point %d of %d\n", n3, N);
            }
            indices.clear();
            distances.clear();
            tree.search(obj_X[n3], K + 1, indices, distances);
            boolean found = false;
            double beta = 1.0;
            double min_beta = -1.7976931348623157E308;
            double max_beta = Double.MAX_VALUE;
            double tol = 1.0E-5;
            int iter = 0;
            double sum_P = 0.0;
            while (!found && iter < 200) {
                sum_P = Double.MIN_VALUE;
                double H = 0.0;
                int m = 0;
                while (m < K) {
                    cur_P[m] = Math.exp(-beta * (Double)distances.get(m + 1));
                    sum_P += cur_P[m];
                    H += beta * ((Double)distances.get(m + 1) * cur_P[m]);
                    ++m;
                }
                double Hdiff = (H = H / sum_P + Math.log(sum_P)) - Math.log(perplexity);
                if (Hdiff < tol && -Hdiff < tol) {
                    found = true;
                } else if (Hdiff > 0.0) {
                    min_beta = beta;
                    beta = max_beta == Double.MAX_VALUE || max_beta == -1.7976931348623157E308 ? (beta *= 2.0) : (beta + max_beta) / 2.0;
                } else {
                    max_beta = beta;
                    beta = min_beta == -1.7976931348623157E308 || min_beta == Double.MAX_VALUE ? (beta /= 2.0) : (beta + min_beta) / 2.0;
                }
                ++iter;
            }
            int m = 0;
            while (m < K) {
                int n4 = m;
                cur_P[n4] = cur_P[n4] / sum_P;
                col_P[row_P[n3] + m] = ((DataPoint)indices.get(m + 1)).index();
                val_P[row_P[n3] + m] = cur_P[m];
                ++m;
            }
            ++n3;
        }
    }

    void computeGaussianPerplexity(double[] X, int N, int D, int[] _row_P, int[] _col_P, double[] _val_P, double perplexity, double threshold) {
        double[] buff = new double[D];
        double[] DD = new double[N];
        double[] cur_P = new double[N];
        int total_count = 0;
        int n = 0;
        while (n < N) {
            int m = 0;
            while (m < N) {
                int d = 0;
                while (d < D) {
                    buff[d] = X[n * D + d];
                    ++d;
                }
                d = 0;
                while (d < D) {
                    int n2 = d;
                    buff[n2] = buff[n2] - X[m * D + d];
                    ++d;
                }
                DD[m] = 0.0;
                d = 0;
                while (d < D) {
                    int n3 = m;
                    DD[n3] = DD[n3] + buff[d] * buff[d];
                    ++d;
                }
                ++m;
            }
            boolean found = false;
            double beta = 1.0;
            double min_beta = -1.7976931348623157E308;
            double max_beta = Double.MAX_VALUE;
            double tol = 1.0E-5;
            int iter = 0;
            double sum_P = 0.0;
            while (!found && iter < 200) {
                int m2 = 0;
                while (m2 < N) {
                    cur_P[m2] = Math.exp(-beta * DD[m2]);
                    ++m2;
                }
                cur_P[n] = Double.MIN_VALUE;
                sum_P = Double.MIN_VALUE;
                m2 = 0;
                while (m2 < N) {
                    sum_P += cur_P[m2];
                    ++m2;
                }
                double H = 0.0;
                int m3 = 0;
                while (m3 < N) {
                    H += beta * (DD[m3] * cur_P[m3]);
                    ++m3;
                }
                double Hdiff = (H = H / sum_P + Math.log(sum_P)) - Math.log(perplexity);
                if (Hdiff < tol && -Hdiff < tol) {
                    found = true;
                } else if (Hdiff > 0.0) {
                    min_beta = beta;
                    beta = max_beta == Double.MAX_VALUE || max_beta == -1.7976931348623157E308 ? (beta *= 2.0) : (beta + max_beta) / 2.0;
                } else {
                    max_beta = beta;
                    beta = min_beta == -1.7976931348623157E308 || min_beta == Double.MAX_VALUE ? (beta /= 2.0) : (beta + min_beta) / 2.0;
                }
                ++iter;
            }
            int m4 = 0;
            while (m4 < N) {
                int n4 = m4++;
                cur_P[n4] = cur_P[n4] / sum_P;
            }
            m4 = 0;
            while (m4 < N) {
                if (cur_P[m4] > threshold / (double)N) {
                    ++total_count;
                }
                ++m4;
            }
            ++n;
        }
        _row_P = new int[N + 1];
        _col_P = new int[total_count];
        _val_P = new double[total_count];
        int[] row_P = _row_P;
        int[] col_P = _col_P;
        double[] val_P = _val_P;
        row_P[0] = 0;
        int count = 0;
        int n5 = 0;
        while (n5 < N) {
            int m = 0;
            while (m < N) {
                int d = 0;
                while (d < D) {
                    buff[d] = X[n5 * D + d];
                    ++d;
                }
                d = 0;
                while (d < D) {
                    int n6 = d;
                    buff[n6] = buff[n6] - X[m * D + d];
                    ++d;
                }
                DD[m] = 0.0;
                d = 0;
                while (d < D) {
                    int n7 = m;
                    DD[n7] = DD[n7] + buff[d] * buff[d];
                    ++d;
                }
                ++m;
            }
            boolean found = false;
            double beta = 1.0;
            double min_beta = -1.7976931348623157E308;
            double max_beta = Double.MAX_VALUE;
            double tol = 1.0E-5;
            int iter = 0;
            double sum_P = 0.0;
            while (!found && iter < 200) {
                int m5 = 0;
                while (m5 < N) {
                    cur_P[m5] = Math.exp(-beta * DD[m5]);
                    ++m5;
                }
                cur_P[n5] = Double.MIN_VALUE;
                sum_P = Double.MIN_VALUE;
                m5 = 0;
                while (m5 < N) {
                    sum_P += cur_P[m5];
                    ++m5;
                }
                double H = 0.0;
                int m6 = 0;
                while (m6 < N) {
                    H += beta * (DD[m6] * cur_P[m6]);
                    ++m6;
                }
                double Hdiff = (H = H / sum_P + Math.log(sum_P)) - Math.log(perplexity);
                if (Hdiff < tol && -Hdiff < tol) {
                    found = true;
                } else if (Hdiff > 0.0) {
                    min_beta = beta;
                    beta = max_beta == Double.MAX_VALUE || max_beta == -1.7976931348623157E308 ? (beta *= 2.0) : (beta + max_beta) / 2.0;
                } else {
                    max_beta = beta;
                    beta = min_beta == -1.7976931348623157E308 || min_beta == Double.MAX_VALUE ? (beta /= 2.0) : (beta + min_beta) / 2.0;
                }
                ++iter;
            }
            int m7 = 0;
            while (m7 < N) {
                int n8 = m7++;
                cur_P[n8] = cur_P[n8] / sum_P;
            }
            m7 = 0;
            while (m7 < N) {
                if (cur_P[m7] > threshold / (double)N) {
                    col_P[count] = m7;
                    val_P[count] = cur_P[m7];
                    ++count;
                }
                ++m7;
            }
            row_P[n5 + 1] = count;
            ++n5;
        }
    }

    SymResult symmetrizeMatrix(int[] _row_P, int[] _col_P, double[] _val_P, int N) {
        int[] row_P = _row_P;
        int[] col_P = _col_P;
        double[] val_P = _val_P;
        int[] row_counts = new int[N];
        int n = 0;
        while (n < N) {
            int i = row_P[n];
            while (i < row_P[n + 1]) {
                boolean present = false;
                int m = row_P[col_P[i]];
                while (m < row_P[col_P[i] + 1]) {
                    if (col_P[m] == n) {
                        present = true;
                    }
                    ++m;
                }
                if (present) {
                    int n2 = n;
                    row_counts[n2] = row_counts[n2] + 1;
                } else {
                    int n3 = n;
                    row_counts[n3] = row_counts[n3] + 1;
                    int n4 = col_P[i];
                    row_counts[n4] = row_counts[n4] + 1;
                }
                ++i;
            }
            ++n;
        }
        int no_elem = 0;
        int n5 = 0;
        while (n5 < N) {
            no_elem += row_counts[n5];
            ++n5;
        }
        int[] sym_row_P = new int[N + 1];
        int[] sym_col_P = new int[no_elem];
        double[] sym_val_P = new double[no_elem];
        sym_row_P[0] = 0;
        int n6 = 0;
        while (n6 < N) {
            sym_row_P[n6 + 1] = sym_row_P[n6] + row_counts[n6];
            ++n6;
        }
        int[] offset = new int[N];
        int n7 = 0;
        while (n7 < N) {
            int i = row_P[n7];
            while (i < row_P[n7 + 1]) {
                boolean present = false;
                int m = row_P[col_P[i]];
                while (m < row_P[col_P[i] + 1]) {
                    if (col_P[m] == n7) {
                        present = true;
                        if (n7 <= col_P[i]) {
                            sym_col_P[sym_row_P[n7] + offset[n7]] = col_P[i];
                            sym_col_P[sym_row_P[col_P[i]] + offset[col_P[i]]] = n7;
                            sym_val_P[sym_row_P[n7] + offset[n7]] = val_P[i] + val_P[m];
                            sym_val_P[sym_row_P[col_P[i]] + offset[col_P[i]]] = val_P[i] + val_P[m];
                        }
                    }
                    ++m;
                }
                if (!present) {
                    sym_col_P[sym_row_P[n7] + offset[n7]] = col_P[i];
                    sym_col_P[sym_row_P[col_P[i]] + offset[col_P[i]]] = n7;
                    sym_val_P[sym_row_P[n7] + offset[n7]] = val_P[i];
                    sym_val_P[sym_row_P[col_P[i]] + offset[col_P[i]]] = val_P[i];
                }
                if (!present || present && n7 <= col_P[i]) {
                    int n8 = n7;
                    offset[n8] = offset[n8] + 1;
                    if (col_P[i] != n7) {
                        int n9 = col_P[i];
                        offset[n9] = offset[n9] + 1;
                    }
                }
                ++i;
            }
            ++n7;
        }
        int i = 0;
        while (i < no_elem) {
            int n10 = i++;
            sym_val_P[n10] = sym_val_P[n10] / 2.0;
        }
        return new SymResult(sym_row_P, sym_col_P, sym_val_P);
    }

    void computeSquaredEuclideanDistance(double[] X, int N, int D, double[] DD) {
        double[] dataSums = new double[N];
        int n = 0;
        while (n < N) {
            int d = 0;
            while (d < D) {
                int n2 = n;
                dataSums[n2] = dataSums[n2] + X[n * D + d] * X[n * D + d];
                ++d;
            }
            ++n;
        }
        n = 0;
        while (n < N) {
            int m = 0;
            while (m < N) {
                DD[n * N + m] = dataSums[n] + dataSums[m];
                ++m;
            }
            ++n;
        }
    }

    void zeroMean(double[] X, int N, int D) {
        int d;
        double[] mean = new double[D];
        int n = 0;
        while (n < N) {
            d = 0;
            while (d < D) {
                int n2 = d;
                mean[n2] = mean[n2] + X[n * D + d];
                ++d;
            }
            ++n;
        }
        int d2 = 0;
        while (d2 < D) {
            int n3 = d2++;
            mean[n3] = mean[n3] / (double)N;
        }
        n = 0;
        while (n < N) {
            d = 0;
            while (d < D) {
                int n4 = n * D + d;
                X[n4] = X[n4] - mean[d];
                ++d;
            }
            ++n;
        }
    }

    void zeroMean(double[][] X, int N, int D) {
        int d;
        double[] mean = new double[D];
        int n = 0;
        while (n < N) {
            d = 0;
            while (d < D) {
                int n2 = d;
                mean[n2] = mean[n2] + X[n][d];
                ++d;
            }
            ++n;
        }
        int d2 = 0;
        while (d2 < D) {
            int n3 = d2++;
            mean[n3] = mean[n3] / (double)N;
        }
        n = 0;
        while (n < N) {
            d = 0;
            while (d < D) {
                double[] dArray = X[n];
                int n4 = d;
                dArray[n4] = dArray[n4] - mean[d];
                ++d;
            }
            ++n;
        }
    }

    @Override
    public void abort() {
        this.abort = true;
    }

    class SymResult {
        int[] sym_row_P;
        int[] sym_col_P;
        double[] sym_val_P;

        public SymResult(int[] sym_row_P, int[] sym_col_P, double[] sym_val_P) {
            this.sym_row_P = sym_row_P;
            this.sym_col_P = sym_col_P;
            this.sym_val_P = sym_val_P;
        }
    }
}

