/*
 * Decompiled with CFR 0.152.
 */
package com.jujutsu.tsne.barneshut;

import com.jujutsu.utils.MatrixOps;

public class SPTree {
    static final int QT_NODE_CAPACITY = 1;
    protected SPTree parent;
    protected int dimension;
    protected boolean is_leaf;
    protected int size;
    protected int cum_size;
    Cell boundary;
    double[] data;
    double[] center_of_mass;
    int[] index = new int[1];
    SPTree[] children;
    int no_children;

    public SPTree(int D, double[] inp_data, int N) {
        int d;
        int nD = 0;
        double[] mean_Y = new double[D];
        double[] min_Y = new double[D];
        double[] max_Y = new double[D];
        int d2 = 0;
        while (d2 < D) {
            min_Y[d2] = Double.POSITIVE_INFINITY;
            max_Y[d2] = Double.NEGATIVE_INFINITY;
            ++d2;
        }
        int n = 0;
        while (n < N) {
            d = 0;
            while (d < D) {
                int n2 = d;
                mean_Y[n2] = mean_Y[n2] + inp_data[n * D + d];
                if (inp_data[nD + d] < min_Y[d]) {
                    min_Y[d] = inp_data[nD + d];
                }
                if (inp_data[nD + d] > max_Y[d]) {
                    max_Y[d] = inp_data[nD + d];
                }
                ++d;
            }
            nD += D;
            ++n;
        }
        d2 = 0;
        while (d2 < D) {
            int n3 = d2++;
            mean_Y[n3] = mean_Y[n3] / (double)N;
        }
        double[] width = new double[D];
        d = 0;
        while (d < D) {
            width[d] = Math.max(max_Y[d] - mean_Y[d], mean_Y[d] - min_Y[d]) + 1.0E-5;
            ++d;
        }
        this.init(null, D, inp_data, mean_Y, width);
        this.fill(N);
    }

    void init(SPTree inp_parent, int D, double[] inp_data, double[] inp_corner, double[] inp_width) {
        this.parent = inp_parent;
        this.dimension = D;
        this.no_children = 2;
        int d = 1;
        while (d < D) {
            this.no_children *= 2;
            ++d;
        }
        this.data = inp_data;
        this.is_leaf = true;
        this.size = 0;
        this.cum_size = 0;
        this.center_of_mass = new double[D];
        this.boundary = new Cell(this.dimension);
        d = 0;
        while (d < D) {
            this.boundary.setCorner(d, inp_corner[d]);
            this.boundary.setWidth(d, inp_width[d]);
            this.center_of_mass[d] = 0.0;
            ++d;
        }
        this.children = this.getTreeArray(this.no_children);
        int i = 0;
        while (i < this.no_children) {
            this.children[i] = null;
            ++i;
        }
    }

    SPTree(int D, double[] inp_data, int N, double[] inp_corner, double[] inp_width) {
        this.init(null, D, inp_data, inp_corner, inp_width);
        this.fill(N);
    }

    SPTree(int D, double[] inp_data, double[] inp_corner, double[] inp_width) {
        this.init(null, D, inp_data, inp_corner, inp_width);
    }

    SPTree(SPTree inp_parent, int D, double[] inp_data, double[] inp_corner, double[] inp_width) {
        this.init(inp_parent, D, inp_data, inp_corner, inp_width);
    }

    SPTree(SPTree inp_parent, int D, double[] inp_data, int N, double[] inp_corner, double[] inp_width) {
        this.init(inp_parent, D, inp_data, inp_corner, inp_width);
        this.fill(N);
    }

    void setData(double[] inp_data) {
        this.data = inp_data;
    }

    SPTree getParent() {
        return this.parent;
    }

    SPTree[] getTreeArray(int no_children) {
        return new SPTree[no_children];
    }

    boolean insert(int new_index) {
        double[] point = MatrixOps.extractRowFromFlatMatrix(this.data, new_index, this.dimension);
        if (!this.boundary.containsPoint(point)) {
            return false;
        }
        ++this.cum_size;
        double mult1 = (double)(this.cum_size - 1) / (double)this.cum_size;
        double mult2 = 1.0 / (double)this.cum_size;
        int d = 0;
        while (d < this.dimension) {
            int n = d;
            this.center_of_mass[n] = this.center_of_mass[n] * mult1;
            int n2 = d;
            this.center_of_mass[n2] = this.center_of_mass[n2] + mult2 * point[d];
            ++d;
        }
        if (this.is_leaf && this.size < 1) {
            this.index[this.size] = new_index;
            ++this.size;
            return true;
        }
        boolean any_duplicate = false;
        int n = 0;
        while (n < this.size) {
            boolean duplicate = true;
            int d2 = 0;
            while (d2 < this.dimension) {
                if (point[d2] != this.data[this.index[n] * this.dimension + d2]) {
                    duplicate = false;
                    break;
                }
                ++d2;
            }
            any_duplicate = any_duplicate || duplicate;
            ++n;
        }
        if (any_duplicate) {
            return true;
        }
        if (this.is_leaf) {
            this.subdivide();
        }
        int i = 0;
        while (i < this.no_children) {
            if (this.children[i].insert(new_index)) {
                return true;
            }
            ++i;
        }
        assert (false);
        return false;
    }

    void subdivide() {
        double[] new_corner = new double[this.dimension];
        double[] new_width = new double[this.dimension];
        int i = 0;
        while (i < this.no_children) {
            int div = 1;
            int d = 0;
            while (d < this.dimension) {
                new_width[d] = 0.5 * this.boundary.getWidth(d);
                new_corner[d] = i / div % 2 == 1 ? this.boundary.getCorner(d) - 0.5 * this.boundary.getWidth(d) : this.boundary.getCorner(d) + 0.5 * this.boundary.getWidth(d);
                div *= 2;
                ++d;
            }
            this.children[i] = this.getNewTree(this, new_corner, new_width);
            ++i;
        }
        i = 0;
        while (i < this.size) {
            boolean success = false;
            int j = 0;
            while (j < this.no_children) {
                if (!success) {
                    success = this.children[j].insert(this.index[i]);
                }
                ++j;
            }
            this.index[i] = -1;
            ++i;
        }
        this.size = 0;
        this.is_leaf = false;
    }

    SPTree getNewTree(SPTree root, double[] new_corner, double[] new_width) {
        return new SPTree(root, this.dimension, this.data, new_corner, new_width);
    }

    void fill(int N) {
        int i = 0;
        while (i < N) {
            this.insert(i);
            ++i;
        }
    }

    boolean isCorrect() {
        int n = 0;
        while (n < this.size) {
            double[] point = MatrixOps.extractRowFromFlatMatrix(this.data, this.index[n], this.dimension);
            if (!this.boundary.containsPoint(point)) {
                return false;
            }
            ++n;
        }
        if (!this.is_leaf) {
            boolean correct = true;
            int i = 0;
            while (i < this.no_children) {
                correct = correct && this.children[i].isCorrect();
                ++i;
            }
            return correct;
        }
        return true;
    }

    void getAllIndices(int[] indices) {
        this.getAllIndices(indices, 0);
    }

    int getAllIndices(int[] indices, int loc) {
        int i = 0;
        while (i < this.size) {
            indices[loc + i] = this.index[i];
            ++i;
        }
        loc += this.size;
        if (!this.is_leaf) {
            i = 0;
            while (i < this.no_children) {
                loc = this.children[i].getAllIndices(indices, loc);
                ++i;
            }
        }
        return loc;
    }

    int getDepth() {
        if (this.is_leaf) {
            return 1;
        }
        int depth = 0;
        int i = 0;
        while (i < this.no_children) {
            depth = Math.max(depth, this.children[i].getDepth());
            ++i;
        }
        return 1 + depth;
    }

    double computeNonEdgeForces(int point_index, double theta, double[] neg_f, Object accumulator) {
        double[] sum_Q = (double[])accumulator;
        double[] buff = new double[this.dimension];
        if (this.cum_size == 0 || this.is_leaf && this.size == 1 && this.index[0] == point_index) {
            return 0.0;
        }
        double D = 0.0;
        int ind = point_index * this.dimension;
        double max_width = 0.0;
        int d = 0;
        while (d < this.dimension) {
            buff[d] = this.data[ind + d] - this.center_of_mass[d];
            D += buff[d] * buff[d];
            double cur_width = this.boundary.getWidth(d);
            max_width = max_width > cur_width ? max_width : cur_width;
            ++d;
        }
        if (this.is_leaf || max_width / Math.sqrt(D) < theta) {
            D = 1.0 / (1.0 + D);
            double mult = (double)this.cum_size * D;
            sum_Q[0] = sum_Q[0] + mult;
            mult *= D;
            int d2 = 0;
            while (d2 < this.dimension) {
                int n = d2;
                neg_f[n] = neg_f[n] + mult * buff[d2];
                ++d2;
            }
        } else {
            int i = 0;
            while (i < this.no_children) {
                this.children[i].computeNonEdgeForces(point_index, theta, neg_f, sum_Q);
                ++i;
            }
        }
        return sum_Q[0];
    }

    void computeEdgeForces(int[] row_P, int[] col_P, double[] val_P, int N, double[] pos_f) {
        double[] buff = new double[this.dimension];
        int ind1 = 0;
        int ind2 = 0;
        int n = 0;
        while (n < N) {
            int i = row_P[n];
            while (i < row_P[n + 1]) {
                double D = 1.0;
                ind2 = col_P[i] * this.dimension;
                int d = 0;
                while (d < this.dimension) {
                    buff[d] = this.data[ind1 + d] - this.data[ind2 + d];
                    D += buff[d] * buff[d];
                    ++d;
                }
                D = val_P[i] / D;
                d = 0;
                while (d < this.dimension) {
                    int n2 = ind1 + d;
                    pos_f[n2] = pos_f[n2] + D * buff[d];
                    ++d;
                }
                ++i;
            }
            ind1 += this.dimension;
            ++n;
        }
    }

    void print() {
        if (this.cum_size == 0) {
            System.out.printf("Empty node\n", new Object[0]);
            return;
        }
        if (this.is_leaf) {
            System.out.printf("Leaf node; data = [", new Object[0]);
            int i = 0;
            while (i < this.size) {
                double[] point = MatrixOps.extractRowFromFlatMatrix(this.data, this.index[i], this.dimension);
                int d = 0;
                while (d < this.dimension) {
                    System.out.printf("%f, ", point[d]);
                    ++d;
                }
                System.out.printf(" (index = %d)", this.index[i]);
                if (i < this.size - 1) {
                    System.out.printf("\n", new Object[0]);
                } else {
                    System.out.printf("]\n", new Object[0]);
                }
                ++i;
            }
        } else {
            System.out.printf("Intersection node with center-of-mass = [", new Object[0]);
            int d = 0;
            while (d < this.dimension) {
                System.out.printf("%f, ", this.center_of_mass[d]);
                ++d;
            }
            System.out.printf("]; children are:\n", new Object[0]);
            int i = 0;
            while (i < this.no_children) {
                this.children[i].print();
                ++i;
            }
        }
    }

    class Cell {
        int dimension;
        double[] corner;
        double[] width;

        Cell(int inp_dimension) {
            this.dimension = inp_dimension;
            this.corner = new double[this.dimension];
            this.width = new double[this.dimension];
        }

        Cell(int inp_dimension, double[] inp_corner, double[] inp_width) {
            this.dimension = inp_dimension;
            this.corner = new double[this.dimension];
            this.width = new double[this.dimension];
            int d = 0;
            while (d < this.dimension) {
                this.setCorner(d, inp_corner[d]);
                ++d;
            }
            d = 0;
            while (d < this.dimension) {
                this.setWidth(d, inp_width[d]);
                ++d;
            }
        }

        double getCorner(int d) {
            return this.corner[d];
        }

        double getWidth(int d) {
            return this.width[d];
        }

        void setCorner(int d, double val) {
            this.corner[d] = val;
        }

        void setWidth(int d, double val) {
            this.width[d] = val;
        }

        boolean containsPoint(double[] point) {
            int d = 0;
            while (d < this.dimension) {
                if (this.corner[d] - this.width[d] > point[d]) {
                    return false;
                }
                if (this.corner[d] + this.width[d] < point[d]) {
                    return false;
                }
                ++d;
            }
            return true;
        }
    }
}

