/*
 * Decompiled with CFR 0.152.
 */
package com.jujutsu.tsne.barneshut;

import com.jujutsu.tsne.barneshut.DataPoint;
import com.jujutsu.tsne.barneshut.Distance;
import com.jujutsu.tsne.barneshut.DistanceComparator;
import com.jujutsu.tsne.barneshut.EuclideanDistance;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.concurrent.ThreadLocalRandom;

public class VpTree<StorageType> {
    DataPoint[] _items;
    Node _root;
    Distance distance;

    public VpTree() {
        this.distance = new EuclideanDistance();
    }

    public VpTree(Distance distance) {
        this.distance = distance;
    }

    public void create(DataPoint[] items) {
        this._items = (DataPoint[])items.clone();
        this._root = this.buildFromPoints(0, items.length);
    }

    public void search(DataPoint target, int k, List<DataPoint> results, List<Double> distances) {
        PriorityQueue<HeapItem> heap = new PriorityQueue<HeapItem>(k, new Comparator<HeapItem>(){

            @Override
            public int compare(HeapItem o1, HeapItem o2) {
                return -1 * o1.compareTo(o2);
            }
        });
        double tau = Double.MAX_VALUE;
        this._root.search(this._root, target, k, heap, tau);
        results.clear();
        distances.clear();
        while (!heap.isEmpty()) {
            results.add(this._items[heap.peek().index]);
            distances.add(heap.peek().dist);
            heap.remove();
        }
        Collections.reverse(results);
        Collections.reverse(distances);
    }

    public Node buildFromPoints(int lower, int upper) {
        if (upper == lower) {
            return null;
        }
        Node node = this.createNode();
        node.index = lower;
        if (upper - lower > 1) {
            int i = (int)(ThreadLocalRandom.current().nextDouble() * (double)(upper - lower - 1)) + lower;
            this.swap(this._items, lower, i);
            int median = (upper + lower) / 2;
            VpTree.nth_element(this._items, lower + 1, median, upper, new DistanceComparator(this._items[lower], this.distance));
            node.threshold = this.distance(this._items[lower], this._items[median]);
            node.index = lower;
            node.left = this.buildFromPoints(lower + 1, median);
            node.right = this.buildFromPoints(median, upper);
        }
        return node;
    }

    protected Node createNode() {
        return new Node();
    }

    public Node getRoot() {
        return this._root;
    }

    static void nth_element(DataPoint[] array, int low, int mid, int high, DistanceComparator distanceComparator) {
        DataPoint[] tmp = new DataPoint[high - low];
        int i = 0;
        while (i < tmp.length) {
            tmp[i] = array[low + i];
            ++i;
        }
        Arrays.sort(tmp, distanceComparator);
        i = 0;
        while (i < tmp.length) {
            array[low + i] = tmp[i];
            ++i;
        }
    }

    static void nth_element(int[] array, int low, int mid, int high) {
        int[] tmp = new int[high - low];
        int i = 0;
        while (i < tmp.length) {
            tmp[i] = array[low + i];
            ++i;
        }
        Arrays.sort(tmp);
        i = 0;
        while (i < tmp.length) {
            array[low + i] = tmp[i];
            ++i;
        }
    }

    public double distance(DataPoint dataPoint1, DataPoint dataPoint2) {
        return this.distance.distance(dataPoint1, dataPoint2);
    }

    private void swap(DataPoint[] items, int idx1, int idx2) {
        DataPoint dp = items[idx1];
        items[idx1] = items[idx2];
        items[idx2] = dp;
    }

    static class HeapItem
    implements Comparable<HeapItem> {
        int index;
        double dist;

        HeapItem(int index, double dist) {
            this.index = index;
            this.dist = dist;
        }

        @Override
        public int compareTo(HeapItem o) {
            return this.dist < o.dist ? -1 : (this.dist > o.dist ? 1 : 0);
        }

        public String toString() {
            return "HeapItem (index=" + this.index + ",dist=" + this.dist + ")";
        }
    }

    class Node {
        int index;
        double threshold;
        protected Node left;
        protected Node right;

        Node() {
        }

        public String toString() {
            return "Node(id=" + this.index + ")";
        }

        public Node getLeft() {
            return this.left;
        }

        public Node getRight() {
            return this.right;
        }

        double search(Node node, DataPoint target, int k, Queue<HeapItem> heap, double _tau) {
            if (node == null) {
                return _tau;
            }
            double dist = VpTree.this.distance(VpTree.this._items[node.index], target);
            if (dist < _tau) {
                if (heap.size() == k) {
                    heap.remove();
                }
                heap.add(new HeapItem(node.index, dist));
                if (heap.size() == k) {
                    _tau = heap.peek().dist;
                }
            }
            if (node.left == null && node.right == null) {
                return _tau;
            }
            if (dist < node.threshold) {
                if (dist - _tau <= node.threshold) {
                    _tau = this.search(node.left, target, k, heap, _tau);
                }
                if (dist + _tau >= node.threshold) {
                    _tau = this.search(node.right, target, k, heap, _tau);
                }
            } else {
                if (dist + _tau >= node.threshold) {
                    _tau = this.search(node.right, target, k, heap, _tau);
                }
                if (dist - _tau <= node.threshold) {
                    _tau = this.search(node.left, target, k, heap, _tau);
                }
            }
            return _tau;
        }
    }
}

