/*
 * Decompiled with CFR 0.152.
 */
package com.jujutsu.utils;

import org.ejml.data.D1Matrix64F;
import org.ejml.data.DenseMatrix64F;
import org.ejml.ops.CommonOps;

public class EjmlOps {
    public static void maximize(DenseMatrix64F p, double minval) {
        int rows = p.getNumRows();
        int cols = p.getNumCols();
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < cols) {
                double val = p.get(i, j);
                if (val < minval) {
                    p.unsafe_set(j, j, minval);
                }
                ++j;
            }
            ++i;
        }
    }

    public static boolean[][] biggerThan(DenseMatrix64F matrix, double value) {
        boolean[][] equals = new boolean[matrix.numRows][matrix.numCols];
        int i = 0;
        while (i < matrix.numRows) {
            int j = 0;
            while (j < matrix.numCols) {
                equals[i][j] = Double.compare(matrix.get(i, j), value) == 1;
                ++j;
            }
            ++i;
        }
        return equals;
    }

    public static void setDiag(DenseMatrix64F diag, double[] diagElems) {
        int idx = 0;
        while (idx < diag.numCols && idx < diag.numRows && idx < diagElems.length) {
            diag.set(idx, idx, diagElems[idx++]);
        }
    }

    public static void setData(DenseMatrix64F target, double[][] data) {
        int numRows = data.length;
        int numCols = data[0].length;
        double[] targetData = new double[numRows * numCols];
        int pos = 0;
        int i = 0;
        while (i < numRows) {
            double[] row = data[i];
            if (row.length != numCols) {
                throw new IllegalArgumentException("All rows must have the same length");
            }
            System.arraycopy(row, 0, targetData, pos, numCols);
            pos += numCols;
            ++i;
        }
        target.setData(targetData);
    }

    public static void replaceNaN(DenseMatrix64F matrix, double repl) {
        int i = 0;
        while (i < matrix.numRows) {
            int j = 0;
            while (j < matrix.numCols) {
                if (Double.isNaN(matrix.get(i, j))) {
                    matrix.set(i, j, repl);
                }
                ++j;
            }
            ++i;
        }
    }

    public static DenseMatrix64F fillWithRow(DenseMatrix64F matrix, int setrow) {
        int rows = matrix.numRows;
        int cols = matrix.numCols;
        DenseMatrix64F result = new DenseMatrix64F(rows, cols);
        int row = 0;
        while (row < rows) {
            int col = 0;
            while (col < cols) {
                result.set(row, col, matrix.get(setrow, col));
                ++col;
            }
            ++row;
        }
        return result;
    }

    public static DenseMatrix64F tile(DenseMatrix64F matrix, int rowtimes, int coltimes) {
        DenseMatrix64F result = new DenseMatrix64F(matrix.numRows * rowtimes, matrix.numCols * coltimes);
        int i = 0;
        int resultrow = 0;
        while (i < rowtimes) {
            int j = 0;
            while (j < matrix.numRows) {
                int k = 0;
                int resultcol = 0;
                while (k < coltimes) {
                    int l = 0;
                    while (l < matrix.numCols) {
                        result.set(resultrow, resultcol++, matrix.get(j, l));
                        ++l;
                    }
                    ++k;
                }
                ++resultrow;
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static void assignAllLessThan(DenseMatrix64F matrix, double lessthan, double assign) {
        int i = 0;
        while (i < matrix.numRows) {
            int j = 0;
            while (j < matrix.numCols) {
                if (matrix.get(i, j) < lessthan) {
                    matrix.set(i, j, assign);
                }
                ++j;
            }
            ++i;
        }
    }

    public static DenseMatrix64F colMean(DenseMatrix64F y, int i) {
        DenseMatrix64F colmean = new DenseMatrix64F(1, y.numCols);
        CommonOps.sumCols((DenseMatrix64F)y, (DenseMatrix64F)colmean);
        CommonOps.divide((D1Matrix64F)colmean, (double)y.numRows);
        return colmean;
    }

    public static void addRowVector(DenseMatrix64F matrix, DenseMatrix64F rowvector) {
        int i = 0;
        while (i < matrix.numRows) {
            int j = 0;
            while (j < matrix.numCols) {
                matrix.set(i, j, matrix.get(i, j) + rowvector.get(0, j));
                ++j;
            }
            ++i;
        }
    }

    public static void assignAtIndex(DenseMatrix64F num, int[] range, int[] range1, double value) {
        int j = 0;
        while (j < range.length) {
            num.set(range[j], range1[j], value);
            ++j;
        }
    }

    public static double[][] extractDoubleArray(DenseMatrix64F p) {
        int rows = p.getNumRows();
        int cols = p.getNumCols();
        double[][] result = new double[rows][cols];
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < cols) {
                result[i][j] = p.get(i, j);
                ++j;
            }
            ++i;
        }
        return result;
    }
}

