/*
 * Decompiled with CFR 0.152.
 */
package com.jujutsu.utils;

import Jama.Matrix;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.RecursiveAction;
import java.util.concurrent.ThreadLocalRandom;
import org.ejml.data.DenseMatrix64F;

public class MatrixOps {
    Random rnd = new Random();
    static DecimalFormat mydecimalFormat = new DecimalFormat("00.###E0");
    private static ForkJoinPool pool = new ForkJoinPool();
    private static String DEFAULT_TITLE = "Vector";
    public static int noDigits = 4;
    MatrixOp multiplyop = new MatrixOp(){

        @Override
        public double compute(double f1, double f2) {
            return f1 * f2;
        }
    };
    MatrixOp minusop = new MatrixOp(){

        @Override
        public double compute(double f1, double f2) {
            return f1 - f2;
        }
    };

    public static String arrToStr(int[] arr, String title) {
        String res = "";
        res = String.valueOf(res) + title + "[" + arr.length + "]:";
        int j = 0;
        while (j < arr.length) {
            res = String.valueOf(res) + arr[j] + ", ";
            ++j;
        }
        res = String.valueOf(res) + "\n";
        return res;
    }

    public static String arrToStr(double[] arr) {
        return MatrixOps.arrToStr(arr, DEFAULT_TITLE, Integer.MAX_VALUE);
    }

    public static String arrToStr(double[] arr, int maxLen) {
        return MatrixOps.arrToStr(arr, DEFAULT_TITLE, maxLen);
    }

    public static String arrToStr(double[] arr, String title) {
        return MatrixOps.arrToStr(arr, title, Integer.MAX_VALUE);
    }

    public static String arrToStr(double[] arr, String title, int maxLen) {
        String res = "";
        res = String.valueOf(res) + title + "[" + arr.length + "]:";
        int j = 0;
        while (j < arr.length && j < maxLen) {
            res = String.valueOf(res) + MatrixOps.formatDouble(arr[j]) + ", ";
            ++j;
        }
        return res;
    }

    public static String doubleArrayToPrintString(double[][] m) {
        return MatrixOps.doubleArrayToPrintString(m, ", ", Integer.MAX_VALUE, m.length, Integer.MAX_VALUE, "\n");
    }

    public static String doubleArrayToPrintString(double[][] m, int maxRows) {
        return MatrixOps.doubleArrayToPrintString(m, ", ", maxRows, maxRows, Integer.MAX_VALUE, "\n");
    }

    public static String doubleArrayToPrintString(double[][] m, String colDelimiter) {
        return MatrixOps.doubleArrayToPrintString(m, colDelimiter, Integer.MAX_VALUE, -1, Integer.MAX_VALUE, "\n");
    }

    public static String doubleArrayToPrintString(double[][] m, String colDelimiter, int toprowlim) {
        return MatrixOps.doubleArrayToPrintString(m, colDelimiter, toprowlim, -1, Integer.MAX_VALUE, "\n");
    }

    public static String doubleArrayToPrintString(double[][] m, int toprowlim, int btmrowlim) {
        return MatrixOps.doubleArrayToPrintString(m, ", ", toprowlim, btmrowlim, Integer.MAX_VALUE, "\n");
    }

    public static String doubleArrayToPrintString(double[][] m, int toprowlim, int btmrowlim, int collim) {
        return MatrixOps.doubleArrayToPrintString(m, ", ", toprowlim, btmrowlim, collim, "\n");
    }

    public static String doubleArrayToPrintString(double[][] m, String colDelimiter, int toprowlim, int btmrowlim) {
        return MatrixOps.doubleArrayToPrintString(m, colDelimiter, toprowlim, btmrowlim, Integer.MAX_VALUE, "\n");
    }

    public static String doubleArrayToPrintString(double[][] m, String colDelimiter, int toprowlim, int btmrowlim, int collim) {
        return MatrixOps.doubleArrayToPrintString(m, colDelimiter, toprowlim, btmrowlim, collim, "\n");
    }

    /*
     * Unable to fully structure code
     */
    public static String doubleArrayToPrintString(double[][] m, String colDelimiter, int toprowlim, int btmrowlim, int collim, String sentenceDelimiter) {
        str = new StringBuffer(m.length * m[0].length);
        str.append("Dim:" + m.length + " x " + m[0].length + "\n");
        i = 0;
        while (i < m.length && i < toprowlim) {
            rowPref = i < 1000 ? String.format("%03d", new Object[]{i}) : String.format("%04d", new Object[]{i});
            str.append(String.valueOf(rowPref) + ": [");
            j = 0;
            while (j < m[i].length - 1 && j < collim) {
                formatted = MatrixOps.formatDouble(m[i][j]);
                str = str.append(formatted);
                str = str.append(colDelimiter);
                ++j;
            }
            str = str.append(MatrixOps.formatDouble(m[i][m[i].length - 1]));
            if (collim == 0x7FFFFFFF) {
                str.append("]");
            } else {
                str.append("...]");
            }
            if (i < m.length - 1) {
                str = str.append(sentenceDelimiter);
            }
            ++i;
        }
        if (btmrowlim >= 0) ** GOTO lbl30
        return str.toString();
lbl-1000:
        // 1 sources

        {
            ++i;
lbl30:
            // 2 sources

            ** while (i < m.length - btmrowlim)
        }
lbl31:
        // 1 sources

        if (i < m.length) {
            str.append("\t.\n\t.\n\t.\n");
        }
        while (i < m.length) {
            rowPref = i < 1000 ? String.format("%03d", new Object[]{i}) : String.format("%04d", new Object[]{i});
            str.append(String.valueOf(rowPref) + ": [");
            j = 0;
            while (j < m[i].length - 1 && j < collim) {
                str = str.append(MatrixOps.formatDouble(m[i][j]));
                str = str.append(colDelimiter);
                ++j;
            }
            str = str.append(MatrixOps.formatDouble(m[i][m[i].length - 1]));
            if (collim > m[i].length) {
                str.append("]");
            } else {
                str.append(", ...]");
            }
            if (i < m.length - 1) {
                str = str.append(sentenceDelimiter);
            }
            ++i;
        }
        return str.toString();
    }

    public static String formatDouble(double d) {
        if (d == 0.0) {
            return "<0.0>";
        }
        if (d < 1.0E-4 && d > 0.0 || d > -1.0E-4 && d < 0.0) {
            return mydecimalFormat.format(d);
        }
        String formatString = "%." + noDigits + "f";
        return String.format(formatString, d);
    }

    public static String doubleArrayToString(double[][] m) {
        return MatrixOps.doubleArrayToString(m, ",");
    }

    public static String doubleArrayToString(double[][] m, String colDelimiter) {
        StringBuffer str = new StringBuffer(m.length * m[0].length);
        int i = 0;
        while (i < m.length) {
            int j = 0;
            while (j < m[i].length - 1) {
                str = str.append(Double.toString(m[i][j]));
                str = str.append(colDelimiter);
                ++j;
            }
            str = str.append(Double.toString(m[i][m[i].length - 1]));
            str = str.append("\n");
            ++i;
        }
        return str.toString();
    }

    public static double[] rep(double val, int times) {
        double[] res = new double[times];
        int i = 0;
        while (i < res.length) {
            res[i] = val;
            ++i;
        }
        return res;
    }

    public static double[] asVector(double[][] matrix) {
        int n;
        boolean isCol = matrix.length != 1;
        int n2 = n = matrix.length == 1 ? matrix[0].length : matrix.length;
        if (matrix.length != 1 && matrix[0].length != 1) {
            throw new IllegalArgumentException("Cannot convert non-row or col matrix to vactor! Matrix dim: " + matrix.length + "x" + matrix[0].length);
        }
        double[] res = new double[n];
        if (isCol) {
            int j = 0;
            while (j < matrix.length) {
                res[j] = matrix[j][0];
                ++j;
            }
        } else {
            int j = 0;
            while (j < matrix[0].length) {
                res[j] = matrix[0][j];
                ++j;
            }
        }
        return res;
    }

    public static double[][] centerAndScaleGlobal(double[][] matrix) {
        double[][] res = new double[matrix.length][matrix[0].length];
        double mean = MatrixOps.mean(matrix);
        double std = MatrixOps.stdev(matrix);
        int i = 0;
        while (i < res.length) {
            int j = 0;
            while (j < res[i].length) {
                res[i][j] = (matrix[i][j] - mean) / std;
                ++j;
            }
            ++i;
        }
        return res;
    }

    public static double[][] centerAndScale(double[][] matrix) {
        double[][] res = new double[matrix.length][matrix[0].length];
        double[] means = MatrixOps.colMeans(matrix);
        int i = 0;
        while (i < res.length) {
            int j = 0;
            while (j < res[i].length) {
                res[i][j] = matrix[i][j] - means[j];
                ++j;
            }
            ++i;
        }
        double[] std = MatrixOps.colStddev(res);
        int i2 = 0;
        while (i2 < res.length) {
            int j = 0;
            while (j < res[i2].length) {
                res[i2][j] = res[i2][j] / (std[j] == 0.0 ? 1.0 : std[j]);
                ++j;
            }
            ++i2;
        }
        return res;
    }

    public static double[][] centerAndScaleSametime(double[][] matrix) {
        double[][] res = new double[matrix.length][matrix[0].length];
        double[] means = MatrixOps.colMeans(matrix);
        double[] std = MatrixOps.colStddev(matrix);
        int i = 0;
        while (i < res.length) {
            int j = 0;
            while (j < res[i].length) {
                res[i][j] = (matrix[i][j] - means[j]) / (std[j] == 0.0 ? 1.0 : std[j]);
                ++j;
            }
            ++i;
        }
        return res;
    }

    public static double[][] addNoise(double[][] matrix) {
        double[][] res = new double[matrix.length][matrix[0].length];
        double[] std = MatrixOps.colStddev(matrix);
        int i = 0;
        while (i < res.length) {
            int j = 0;
            while (j < res[i].length) {
                double noise = MatrixOps.rnorm(0.0, std[j] == 0.0 ? 1.0E-5 : std[j] / 5.0);
                res[i][j] = matrix[i][j] + noise;
                ++j;
            }
            ++i;
        }
        return res;
    }

    public static double[][] transposeSerial(double[][] matrix) {
        int rows = matrix.length;
        int cols = matrix[0].length;
        double[][] transpose = new double[cols][rows];
        int col = 0;
        while (col < cols) {
            int row = 0;
            while (row < rows) {
                transpose[col][row] = matrix[row][col];
                ++row;
            }
            ++col;
        }
        return transpose;
    }

    public double[][] transpose(double[][] matrix) {
        return this.transpose(matrix, 1000);
    }

    public double[][] transpose(double[][] matrix, int ll) {
        int cols = matrix[0].length;
        int rows = matrix.length;
        double[][] transpose = new double[cols][rows];
        if (rows < 100) {
            int i = 0;
            while (i < cols) {
                int j = 0;
                while (j < rows) {
                    transpose[i][j] = matrix[j][i];
                    ++j;
                }
                ++i;
            }
        } else {
            MatrixTransposer process = new MatrixTransposer(matrix, transpose, 0, rows, ll);
            pool.invoke(process);
        }
        return transpose;
    }

    public static double[][] exp(double[][] m1) {
        double[][] matrix = new double[m1.length][m1[0].length];
        int i = 0;
        while (i < matrix.length) {
            int j = 0;
            while (j < matrix[0].length) {
                matrix[i][j] = Math.exp(m1[i][j]);
                ++j;
            }
            ++i;
        }
        return matrix;
    }

    public static double[] sqrt(double[] v1) {
        double[] vector = new double[v1.length];
        int i = 0;
        while (i < vector.length) {
            vector[i] = Math.sqrt(v1[i]);
            ++i;
        }
        return vector;
    }

    public static double mean(double[] vector) {
        double sum = 0.0;
        int i = 0;
        while (i < vector.length) {
            sum += vector[i];
            ++i;
        }
        return sum / (double)vector.length;
    }

    public static double[][] log(double[][] m1) {
        double[][] matrix = new double[m1.length][m1[0].length];
        int i = 0;
        while (i < matrix.length) {
            int j = 0;
            while (j < matrix[0].length) {
                matrix[i][j] = Math.log(m1[i][j]);
                ++j;
            }
            ++i;
        }
        return matrix;
    }

    public static double[][] pow(double[][] m1, double power) {
        double[][] matrix = new double[m1.length][m1[0].length];
        int i = 0;
        while (i < matrix.length) {
            int j = 0;
            while (j < matrix[0].length) {
                matrix[i][j] = Math.pow(m1[i][j], power);
                ++j;
            }
            ++i;
        }
        return matrix;
    }

    public static double[] pow(double[] m1, double power) {
        double[] matrix = new double[m1.length];
        int i = 0;
        while (i < matrix.length) {
            matrix[i] = Math.pow(m1[i], power);
            ++i;
        }
        return matrix;
    }

    public static double[][] log(double[][] m1, boolean infAsZero) {
        double[][] matrix = new double[m1.length][m1[0].length];
        int i = 0;
        while (i < matrix.length) {
            int j = 0;
            while (j < matrix[0].length) {
                matrix[i][j] = Math.log(m1[i][j]);
                if (infAsZero && Double.isInfinite(matrix[i][j])) {
                    matrix[i][j] = 0.0;
                }
                ++j;
            }
            ++i;
        }
        return matrix;
    }

    public static double[][] scalarInverse(double[][] m1) {
        double[][] matrix = new double[m1.length][m1[0].length];
        int i = 0;
        while (i < matrix.length) {
            int j = 0;
            while (j < matrix[0].length) {
                matrix[i][j] = 1.0 / m1[i][j];
                ++j;
            }
            ++i;
        }
        return matrix;
    }

    public static double[] scalarInverse(double[] v1) {
        double[] vector = new double[v1.length];
        int i = 0;
        while (i < vector.length) {
            vector[i] = 1.0 / v1[i];
            ++i;
        }
        return vector;
    }

    public static double[][] rnorm(int m, int n) {
        double[][] array = new double[m][n];
        int i = 0;
        while (i < m) {
            int j = 0;
            while (j < array[i].length) {
                array[i][j] = MatrixOps.rnorm(0.0, 1.0);
                ++j;
            }
            ++i;
        }
        return array;
    }

    public static double[] rnorm(int n, double[] mus, double[] sigmas) {
        double[] res = new double[n];
        int i = 0;
        while (i < res.length) {
            res[i] = mus[i] + ThreadLocalRandom.current().nextGaussian() * sigmas[i];
            ++i;
        }
        return res;
    }

    public static double[] rnorm(int n, double mu, double[] sigmas) {
        double[] res = new double[n];
        int i = 0;
        while (i < res.length) {
            res[i] = mu + ThreadLocalRandom.current().nextGaussian() * sigmas[i];
            ++i;
        }
        return res;
    }

    public static double rnorm() {
        return ThreadLocalRandom.current().nextGaussian();
    }

    public static double rnorm(double mu, double sigma) {
        return mu + ThreadLocalRandom.current().nextGaussian() * sigma;
    }

    public static boolean[][] equal(double[][] matrix1, double[][] matrix2) {
        boolean[][] equals = new boolean[matrix1.length][matrix1[0].length];
        if (matrix1.length != matrix2.length) {
            throw new IllegalArgumentException("Dimensions does not match");
        }
        if (matrix1[0].length != matrix2[0].length) {
            throw new IllegalArgumentException("Dimensions does not match");
        }
        int i = 0;
        while (i < matrix1.length) {
            int j = 0;
            while (j < matrix1[0].length) {
                equals[i][j] = Double.compare(matrix1[i][j], matrix2[i][j]) == 0;
                ++j;
            }
            ++i;
        }
        return equals;
    }

    public static boolean[][] equal(boolean[][] matrix1, boolean[][] matrix2) {
        boolean[][] equals = new boolean[matrix1.length][matrix1[0].length];
        if (matrix1.length != matrix2.length) {
            throw new IllegalArgumentException("Dimensions does not match");
        }
        if (matrix1[0].length != matrix2[0].length) {
            throw new IllegalArgumentException("Dimensions does not match");
        }
        int i = 0;
        while (i < matrix1.length) {
            int j = 0;
            while (j < matrix1[0].length) {
                equals[i][j] = matrix1[i][j] == matrix2[i][j];
                ++j;
            }
            ++i;
        }
        return equals;
    }

    public static boolean[][] biggerThan(double[][] matrix, double value) {
        boolean[][] equals = new boolean[matrix.length][matrix[0].length];
        int i = 0;
        while (i < matrix.length) {
            int j = 0;
            while (j < matrix[0].length) {
                equals[i][j] = Double.compare(matrix[i][j], value) == 1;
                ++j;
            }
            ++i;
        }
        return equals;
    }

    public static boolean[][] negate(boolean[][] booleans) {
        boolean[][] negates = new boolean[booleans.length][booleans[0].length];
        int i = 0;
        while (i < booleans.length) {
            int j = 0;
            while (j < booleans[0].length) {
                negates[i][j] = !booleans[i][j];
                ++j;
            }
            ++i;
        }
        return negates;
    }

    public static double[][] abs(boolean[][] booleans) {
        double[][] absolutes = new double[booleans.length][booleans[0].length];
        int i = 0;
        while (i < booleans.length) {
            int j = 0;
            while (j < booleans[0].length) {
                absolutes[i][j] = booleans[i][j] ? 1 : 0;
                ++j;
            }
            ++i;
        }
        return absolutes;
    }

    public static double[][] abs(double[][] vals) {
        double[][] absolutes = new double[vals.length][vals[0].length];
        int i = 0;
        while (i < vals.length) {
            int j = 0;
            while (j < vals[0].length) {
                absolutes[i][j] = Math.abs(vals[i][j]);
                ++j;
            }
            ++i;
        }
        return absolutes;
    }

    public static double[] abs(double[] vals) {
        double[] absolutes = new double[vals.length];
        int i = 0;
        while (i < vals.length) {
            absolutes[i] = Math.abs(vals[i]);
            ++i;
        }
        return absolutes;
    }

    public static double[][] sign(double[][] matrix) {
        double[][] signs = new double[matrix.length][matrix[0].length];
        int i = 0;
        while (i < matrix.length) {
            int j = 0;
            while (j < matrix[0].length) {
                signs[i][j] = matrix[i][j] >= 0.0 ? 1 : -1;
                ++j;
            }
            ++i;
        }
        return signs;
    }

    public static double mean(double[][] matrix) {
        return MatrixOps.mean(matrix, 2)[0][0];
    }

    public static double[][] mean(double[][] matrix, int axis) {
        double[][] result;
        if (axis == 0) {
            result = new double[1][matrix[0].length];
            int j = 0;
            while (j < matrix[0].length) {
                double colsum = 0.0;
                int i = 0;
                while (i < matrix.length) {
                    colsum += matrix[i][j];
                    ++i;
                }
                result[0][j] = colsum / (double)matrix.length;
                ++j;
            }
        } else if (axis == 1) {
            result = new double[matrix.length][1];
            int i = 0;
            while (i < matrix.length) {
                double rowsum = 0.0;
                int j = 0;
                while (j < matrix[0].length) {
                    rowsum += matrix[i][j];
                    ++j;
                }
                result[i][0] = rowsum / (double)matrix[0].length;
                ++i;
            }
        } else if (axis == 2) {
            result = new double[1][1];
            int j = 0;
            while (j < matrix[0].length) {
                int i = 0;
                while (i < matrix.length) {
                    double[] dArray = result[0];
                    dArray[0] = dArray[0] + matrix[i][j];
                    ++i;
                }
                ++j;
            }
            double[] dArray = result[0];
            dArray[0] = dArray[0] / (double)(matrix[0].length * matrix.length);
        } else {
            throw new IllegalArgumentException("Axes other than 0,1,2 is unsupported");
        }
        return result;
    }

    public static double[][] sum(double[][] matrix, int axis) {
        double[][] result;
        if (axis == 0) {
            result = new double[1][matrix[0].length];
            int j = 0;
            while (j < matrix[0].length) {
                double rowsum = 0.0;
                int i = 0;
                while (i < matrix.length) {
                    rowsum += matrix[i][j];
                    ++i;
                }
                result[0][j] = rowsum;
                ++j;
            }
        } else if (axis == 1) {
            result = new double[matrix.length][1];
            int i = 0;
            while (i < matrix.length) {
                double colsum = 0.0;
                int j = 0;
                while (j < matrix[0].length) {
                    colsum += matrix[i][j];
                    ++j;
                }
                result[i][0] = colsum;
                ++i;
            }
        } else {
            throw new IllegalArgumentException("Axes other than 0,1 is unsupported");
        }
        return result;
    }

    public double sumPar(double[][] matrix) {
        int ll = 100;
        int cols = matrix[0].length;
        int rows = matrix.length;
        double[] sums = new double[rows];
        if (rows < ll) {
            int row = 0;
            while (row < rows) {
                int col = 0;
                while (col < cols) {
                    int n = row;
                    sums[n] = sums[n] + matrix[row][col];
                    ++col;
                }
                ++row;
            }
        } else {
            MatrixSummer process = new MatrixSummer(matrix, sums, 0, rows, ll);
            pool.invoke(process);
        }
        double sum = 0.0;
        int i = 0;
        while (i < sums.length) {
            sum += sums[i];
            ++i;
        }
        return sum;
    }

    public static double sum(double[][] matrix) {
        double sum = 0.0;
        int i = 0;
        while (i < matrix.length) {
            int j = 0;
            while (j < matrix[0].length) {
                sum += matrix[i][j];
                ++j;
            }
            ++i;
        }
        return sum;
    }

    public static double sum(double[] vector) {
        double res = 0.0;
        int i = 0;
        while (i < vector.length) {
            res += vector[i];
            ++i;
        }
        return res;
    }

    public static double[][] maximum(double[][] matrix, double maxval) {
        double[][] maxed = new double[matrix.length][matrix[0].length];
        int i = 0;
        while (i < matrix.length) {
            int j = 0;
            while (j < matrix[0].length) {
                maxed[i][j] = matrix[i][j] > maxval ? matrix[i][j] : maxval;
                ++j;
            }
            ++i;
        }
        return maxed;
    }

    public static void assignAllLessThan(double[][] matrix, double lessthan, double assign) {
        int i = 0;
        while (i < matrix.length) {
            int j = 0;
            while (j < matrix[0].length) {
                if (matrix[i][j] < lessthan) {
                    matrix[i][j] = assign;
                }
                ++j;
            }
            ++i;
        }
    }

    public static double[][] square(double[][] matrix) {
        return MatrixOps.scalarPow(matrix, 2.0);
    }

    public static double[][] replaceNaN(double[][] matrix, double repl) {
        double[][] result = new double[matrix.length][matrix[0].length];
        int i = 0;
        while (i < matrix.length) {
            int j = 0;
            while (j < matrix[0].length) {
                result[i][j] = Double.isNaN(matrix[i][j]) ? repl : matrix[i][j];
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static double[][] replaceInf(double[][] matrix, double repl) {
        double[][] result = new double[matrix.length][matrix[0].length];
        int i = 0;
        while (i < matrix.length) {
            int j = 0;
            while (j < matrix[0].length) {
                result[i][j] = Double.isInfinite(matrix[i][j]) ? repl : matrix[i][j];
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static double[][] scalarPow(double[][] matrix, double power) {
        double[][] result = new double[matrix.length][matrix[0].length];
        int i = 0;
        while (i < matrix.length) {
            int j = 0;
            while (j < matrix[0].length) {
                double[] dArray = result[i];
                int n = j;
                dArray[n] = dArray[n] + Math.pow(matrix[i][j], power);
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static double[][] addColumnVector(double[][] matrix, double[][] colvector) {
        double[][] result = new double[matrix.length][matrix[0].length];
        int i = 0;
        while (i < matrix.length) {
            int j = 0;
            while (j < matrix[0].length) {
                result[i][j] = matrix[i][j] + colvector[i][0];
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static double[][] addRowVector(double[][] matrix, double[][] rowvector) {
        double[][] result = new double[matrix.length][matrix[0].length];
        int i = 0;
        while (i < matrix.length) {
            int j = 0;
            while (j < matrix[0].length) {
                result[i][j] = matrix[i][j] + rowvector[0][j];
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static double[][] fillWithRowOld(double[][] matrix, int row) {
        double[][] result = new double[matrix.length][matrix[0].length];
        int i = 0;
        while (i < matrix.length) {
            int j = 0;
            while (j < matrix[0].length) {
                result[i][j] = matrix[row][j];
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static double[][] fillWithRow(double[][] matrix, int row) {
        int rows = matrix.length;
        int cols = matrix[0].length;
        double[][] result = new double[rows][cols];
        int i = 0;
        while (i < rows) {
            System.arraycopy(matrix[row], 0, result[i], 0, cols);
            ++i;
        }
        return result;
    }

    public static double[][] tile(double[][] matrix, int rowtimes, int coltimes) {
        double[][] result = new double[matrix.length * rowtimes][matrix[0].length * coltimes];
        int i = 0;
        int resultrow = 0;
        while (i < rowtimes) {
            int j = 0;
            while (j < matrix.length) {
                int k = 0;
                int resultcol = 0;
                while (k < coltimes) {
                    int l = 0;
                    while (l < matrix[0].length) {
                        result[resultrow][resultcol++] = matrix[j][l];
                        ++l;
                    }
                    ++k;
                }
                ++resultrow;
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static double[][] normalize(double[][] x, double[] meanX, double[] stdevX) {
        double[][] y = new double[x.length][x[0].length];
        int i = 0;
        while (i < y.length) {
            int j = 0;
            while (j < y[i].length) {
                y[i][j] = (x[i][j] - meanX[j]) / stdevX[j];
                ++j;
            }
            ++i;
        }
        return y;
    }

    public static int[] range(int n) {
        int[] result = new int[n];
        int i = 0;
        while (i < n) {
            result[i] = i;
            ++i;
        }
        return result;
    }

    public static int[] range(int a, int b) {
        if (b < a) {
            throw new IllegalArgumentException("b has to be larger than a");
        }
        int val = a;
        int[] result = new int[b - a];
        int i = 0;
        while (i < b - a) {
            result[i] = val++;
            ++i;
        }
        return result;
    }

    public static int[] concatenate(int[] v1, int[] v2) {
        int[] result = new int[v1.length + v2.length];
        int index = 0;
        int i = 0;
        while (i < v1.length) {
            result[index] = v1[index];
            ++i;
            ++index;
        }
        i = 0;
        while (i < v2.length) {
            result[index] = v2[i];
            ++i;
            ++index;
        }
        return result;
    }

    public static double[] concatenate(double[] v1, double[] v2) {
        double[] result = new double[v1.length + v2.length];
        int index = 0;
        int i = 0;
        while (i < v1.length) {
            result[index] = v1[index];
            ++i;
            ++index;
        }
        i = 0;
        while (i < v2.length) {
            result[index] = v2[i];
            ++i;
            ++index;
        }
        return result;
    }

    public static double[][] concatenate(double[][] m1, double[][] m2) {
        if (m1.length != m2.length) {
            throw new IllegalArgumentException("m1 and m2 must have the same number of rows:" + m1.length + " != " + m2.length);
        }
        double[][] result = new double[m1.length][m1[0].length + m2[0].length];
        int resCol = 0;
        int i = 0;
        while (i < m1.length) {
            resCol = 0;
            int j = 0;
            while (j < m1[i].length) {
                result[i][resCol++] = m1[i][j];
                ++j;
            }
            j = 0;
            while (j < m2[i].length) {
                result[i][resCol++] = m2[i][j];
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static double[][] concatenate(double[][] m1, double[] v2) {
        if (m1.length != v2.length) {
            throw new IllegalArgumentException("m1 and v2 must have the same number of rows:" + m1.length + " != " + v2.length);
        }
        double[][] result = new double[m1.length][m1[0].length + 1];
        int resCol = 0;
        int i = 0;
        while (i < m1.length) {
            resCol = 0;
            int j = 0;
            while (j < m1[i].length) {
                result[i][resCol++] = m1[i][j];
                ++j;
            }
            result[i][resCol++] = v2[i];
            ++i;
        }
        return result;
    }

    public double[][] scalarMultiply(double[][] m1, double[][] m2) {
        return this.parScalarMultiply(m1, m2);
    }

    public static double[][] sMultiply(double[][] v1, double[][] v2) {
        if (v1.length != v2.length || v1[0].length != v2[0].length) {
            throw new IllegalArgumentException("a and b has to be of equal dimensions");
        }
        double[][] result = new double[v1.length][v1[0].length];
        int i = 0;
        while (i < v1.length) {
            int j = 0;
            while (j < v1[0].length) {
                result[i][j] = v1[i][j] * v2[i][j];
                ++j;
            }
            ++i;
        }
        return result;
    }

    public double[][] parScalarMultiply(double[][] m1, double[][] m2) {
        int ll = 600;
        double[][] result = new double[m1.length][m1[0].length];
        MatrixOperator process = new MatrixOperator(m1, m2, result, this.multiplyop, 0, m1.length, ll);
        pool.invoke(process);
        return result;
    }

    public double[][] parScalarMinus(double[][] m1, double[][] m2) {
        int ll = 600;
        double[][] result = new double[m1.length][m1[0].length];
        MatrixOperator process = new MatrixOperator(m1, m2, result, this.minusop, 0, m1.length, ll);
        pool.invoke(process);
        return result;
    }

    public static void assignAtIndex(double[][] num, int[] range, int[] range1, double value) {
        int j = 0;
        while (j < range.length) {
            num[range[j]][range1[j]] = value;
            ++j;
        }
    }

    public static double[][] getValuesFromRow(double[][] matrix, int row, int[] indicies) {
        double[][] values = new double[1][indicies.length];
        int j = 0;
        while (j < indicies.length) {
            values[0][j] = matrix[row][indicies[j]];
            ++j;
        }
        return values;
    }

    public static void assignValuesToRow(double[][] matrix, int row, int[] indicies, double[] values) {
        if (indicies.length != values.length) {
            throw new IllegalArgumentException("Length of indicies and values have to be equal");
        }
        int j = 0;
        while (j < indicies.length) {
            matrix[row][indicies[j]] = values[j];
            ++j;
        }
    }

    public static double stdev(double[][] matrix) {
        double m = MatrixOps.mean(matrix);
        double total = 0.0;
        int N = matrix.length * matrix[0].length;
        int i = 0;
        while (i < matrix.length) {
            int j = 0;
            while (j < matrix[i].length) {
                double x = matrix[i][j];
                total += (x - m) * (x - m);
                ++j;
            }
            ++i;
        }
        return Math.sqrt(total / (double)(N - 1));
    }

    public static double[] colStddev(double[][] v) {
        double[] var = MatrixOps.variance(v);
        int i = 0;
        while (i < var.length) {
            var[i] = Math.sqrt(var[i]);
            ++i;
        }
        return var;
    }

    public static double[] variance(double[][] v) {
        int m = v.length;
        int n = v[0].length;
        double[] var = new double[n];
        int degrees = m - 1;
        int j = 0;
        while (j < n) {
            double c = 0.0;
            double s = 0.0;
            int k = 0;
            while (k < m) {
                s += v[k][j];
                ++k;
            }
            s /= (double)m;
            k = 0;
            while (k < m) {
                c += (v[k][j] - s) * (v[k][j] - s);
                ++k;
            }
            var[j] = c / (double)degrees;
            ++j;
        }
        return var;
    }

    public static double[] colMeans(double[][] matrix) {
        int rows = matrix.length;
        int cols = matrix[0].length;
        double[] mean = new double[cols];
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < cols) {
                int n = j;
                mean[n] = mean[n] + matrix[i][j];
                ++j;
            }
            ++i;
        }
        int j = 0;
        while (j < cols) {
            int n = j++;
            mean[n] = mean[n] / (double)rows;
        }
        return mean;
    }

    public static double[][] copyRows(double[][] input, int ... indices) {
        double[][] matrix = new double[indices.length][input[0].length];
        int i = 0;
        while (i < indices.length) {
            System.arraycopy(input[indices[i]], 0, matrix[i], 0, input[indices[i]].length);
            ++i;
        }
        return matrix;
    }

    public static double[][] copyCols(double[][] input, int ... indices) {
        double[][] matrix = new double[indices.length][input.length];
        int i = 0;
        while (i < indices.length) {
            int j = 0;
            while (j < input.length) {
                matrix[i][j] = input[j][indices[i]];
                ++j;
            }
            ++i;
        }
        return matrix;
    }

    public static double[][] fillMatrix(int rows, int cols, double fillvalue) {
        double[][] matrix = new double[rows][cols];
        int i = 0;
        while (i < matrix.length) {
            int j = 0;
            while (j < matrix[i].length) {
                matrix[i][j] = fillvalue;
                ++j;
            }
            ++i;
        }
        return matrix;
    }

    public static double[][] plus(double[][] m1, double[][] m2) {
        double[][] matrix = new double[m1.length][m1[0].length];
        int i = 0;
        while (i < m1.length) {
            int j = 0;
            while (j < m1[0].length) {
                matrix[i][j] = m1[i][j] + m2[i][j];
                ++j;
            }
            ++i;
        }
        return matrix;
    }

    public static double[][] scalarPlus(double[][] m1, double m2) {
        double[][] matrix = new double[m1.length][m1[0].length];
        int i = 0;
        while (i < m1.length) {
            int j = 0;
            while (j < m1[0].length) {
                matrix[i][j] = m1[i][j] + m2;
                ++j;
            }
            ++i;
        }
        return matrix;
    }

    public static double[] scalarPlus(double[] m1, double m2) {
        double[] matrix = new double[m1.length];
        int i = 0;
        while (i < m1.length) {
            matrix[i] = m1[i] + m2;
            ++i;
        }
        return matrix;
    }

    public double[][] minus(double[][] m1, double[][] m2) {
        return this.parScalarMinus(m1, m2);
    }

    public static double[][] sMinus(double[][] m1, double[][] m2) {
        double[][] matrix = new double[m1.length][m1[0].length];
        int i = 0;
        while (i < m1.length) {
            int j = 0;
            while (j < m1[0].length) {
                matrix[i][j] = m1[i][j] - m2[i][j];
                ++j;
            }
            ++i;
        }
        return matrix;
    }

    public static double[][] scalarDivide(double[][] numerator, double denom) {
        double[][] matrix = new double[numerator.length][numerator[0].length];
        int i = 0;
        while (i < numerator.length) {
            int j = 0;
            while (j < numerator[i].length) {
                matrix[i][j] = numerator[i][j] / denom;
                ++j;
            }
            ++i;
        }
        return matrix;
    }

    public static double[] scalarDivide(double numerator, double[] denom) {
        double[] vector = new double[denom.length];
        int i = 0;
        while (i < denom.length) {
            vector[i] = numerator / denom[i];
            ++i;
        }
        return vector;
    }

    public static double[] scalarDivide(double[] numerator, double denom) {
        double[] vector = new double[numerator.length];
        int i = 0;
        while (i < numerator.length) {
            vector[i] = numerator[i] / denom;
            ++i;
        }
        return vector;
    }

    public static double[] scalarDivide(double[] numerator, double[] denom) {
        double[] vector = new double[denom.length];
        int i = 0;
        while (i < denom.length) {
            vector[i] = numerator[i] / denom[i];
            ++i;
        }
        return vector;
    }

    public static double[][] scalarDivide(double[][] numerator, double[][] denom) {
        double[][] matrix = new double[numerator.length][numerator[0].length];
        int i = 0;
        while (i < numerator.length) {
            int j = 0;
            while (j < numerator[i].length) {
                matrix[i][j] = numerator[i][j] / denom[i][j];
                ++j;
            }
            ++i;
        }
        return matrix;
    }

    public static double[][] scalarMult(double[][] m1, double mul) {
        double[][] matrix = new double[m1.length][m1[0].length];
        int i = 0;
        while (i < m1.length) {
            int j = 0;
            while (j < m1[i].length) {
                matrix[i][j] = m1[i][j] * mul;
                ++j;
            }
            ++i;
        }
        return matrix;
    }

    public static double[][] times(double[][] m1, double[][] m2) {
        Matrix A = Matrix.constructWithCopy((double[][])m1);
        Matrix B = Matrix.constructWithCopy((double[][])m2);
        return A.times(B).getArray();
    }

    public static double[] scalarMultiply(double[] m1, double mul) {
        double[] matrix = new double[m1.length];
        int i = 0;
        while (i < m1.length) {
            matrix[i] = m1[i] * mul;
            ++i;
        }
        return matrix;
    }

    public static double[] scalarMultiply(double[] m1, double[] m2) {
        double[] matrix = new double[m1.length];
        int i = 0;
        while (i < m1.length) {
            matrix[i] = m1[i] * m2[i];
            ++i;
        }
        return matrix;
    }

    public static double[][] diag(double[][] ds) {
        boolean isLong = ds.length > ds[0].length;
        int dim = Math.max(ds.length, ds[0].length);
        double[][] result = new double[dim][dim];
        int i = 0;
        while (i < result.length) {
            int j = 0;
            while (j < result.length) {
                if (i == j) {
                    result[i][j] = isLong ? ds[i][0] : ds[0][i];
                }
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static double[][] dot(double[][] a, double[][] b) {
        if (a[0].length != b.length) {
            throw new IllegalArgumentException("Dims does not match: " + a[0].length + "!=" + b.length);
        }
        double[][] res = new double[a.length][b[0].length];
        int row = 0;
        while (row < a.length) {
            int col = 0;
            while (col < b[row].length) {
                int i = 0;
                while (i < a[0].length) {
                    res[row][col] = a[row][i] * b[i][col];
                    ++i;
                }
                ++col;
            }
            ++row;
        }
        return res;
    }

    public static double dot(double[] a, double[] b) {
        if (a.length != b.length) {
            throw new IllegalArgumentException("Vectors are not of equal length");
        }
        double res = 0.0;
        int i = 0;
        while (i < b.length) {
            res += a[i] * b[i];
            ++i;
        }
        return res;
    }

    public static double dot2P1(double[] a1, double[] a2, double[] b) {
        if (a1.length + a2.length != b.length) {
            throw new IllegalArgumentException("Vectors are not of equal length");
        }
        double res = 0.0;
        int bidx = 0;
        int i = 0;
        while (i < a1.length) {
            res += a1[i] * b[bidx];
            ++i;
            ++bidx;
        }
        i = 0;
        while (i < a2.length) {
            res += a2[i] * b[bidx];
            ++i;
            ++bidx;
        }
        return res;
    }

    public static int maxIdx(double[] probs) {
        int maxIdx = 0;
        double max = probs[maxIdx];
        int i = 0;
        while (i < probs.length) {
            if (probs[i] > max) {
                max = probs[i];
                maxIdx = i;
            }
            ++i;
        }
        return maxIdx;
    }

    public static double[][] extractCol(int col, double[][] matrix) {
        double[][] res = new double[matrix.length][1];
        int row = 0;
        while (row < matrix.length) {
            res[row][0] = matrix[row][col];
            ++row;
        }
        return res;
    }

    public static double[] extractColVector(int col, double[][] matrix) {
        double[] res = new double[matrix.length];
        int row = 0;
        while (row < matrix.length) {
            res[row] = matrix[row][col];
            ++row;
        }
        return res;
    }

    public static double[][] extractDoubleArray(DenseMatrix64F p) {
        int rows = p.getNumRows();
        int cols = p.getNumCols();
        double[][] result = new double[rows][cols];
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < cols) {
                result[i][j] = p.get(i, j);
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static double[] extractDoubleVector(DenseMatrix64F p) {
        double[] result;
        int rows = p.getNumRows();
        int cols = p.getNumCols();
        if (rows != 1 && cols != 1) {
            throw new IllegalArgumentException("Cannot convert a " + rows + "x" + cols + " matrix to a vector");
        }
        if (cols == 1) {
            result = new double[rows];
            int j = 0;
            while (j < rows) {
                result[j] = p.get(j, 0);
                ++j;
            }
        } else {
            result = new double[cols];
            int j = 0;
            while (j < cols) {
                result[j] = p.get(0, j);
                ++j;
            }
        }
        return result;
    }

    public static double[][] extractRowCols(int col, double[][] zs2, int[] cJIdxs) {
        double[][] res = new double[cJIdxs.length][1];
        int row = 0;
        while (row < cJIdxs.length) {
            res[row][0] = zs2[cJIdxs[row]][col];
            ++row;
        }
        return res;
    }

    public static Integer[] indicesOf(int classIdx, int[] ys) {
        ArrayList<Integer> indices = new ArrayList<Integer>();
        int row = 0;
        while (row < ys.length) {
            if (ys[row] == classIdx) {
                indices.add(row);
            }
            ++row;
        }
        return indices.toArray(new Integer[0]);
    }

    public static double[][] makeDesignMatrix(double[][] xstmp) {
        double[][] xs = new double[xstmp.length][xstmp[0].length + 1];
        int row = 0;
        while (row < xs.length) {
            int col = 0;
            while (col < xs[0].length) {
                xs[row][col] = col == 0 ? 1.0 : xstmp[row][col - 1];
                ++col;
            }
            ++row;
        }
        return xs;
    }

    public static double[][] addIntercept(double[][] xs) {
        double[][] result = new double[xs.length][xs[0].length + 1];
        int i = 0;
        while (i < result.length) {
            int j = 0;
            while (j < result[0].length) {
                result[i][j] = j == 0 ? 1.0 : xs[i][j - 1];
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static double[] toPrimitive(Double[] ds) {
        double[] result = new double[ds.length];
        int i = 0;
        while (i < ds.length) {
            result[i] = ds[i];
            ++i;
        }
        return result;
    }

    public static double[] extractRowFromFlatMatrix(double[] flatMatrix, int rowIdx, int dimension) {
        double[] point = new double[dimension];
        int offset = rowIdx * dimension;
        int j = 0;
        while (j < dimension) {
            point[j] = flatMatrix[offset + j];
            ++j;
        }
        return point;
    }

    public static interface MatrixOp {
        public double compute(double var1, double var3);
    }

    class MatrixOperator
    extends RecursiveAction {
        static final long serialVersionUID = 1L;
        double[][] matrix1;
        double[][] matrix2;
        double[][] resultMatrix;
        int startRow = -1;
        int endRow = -1;
        int limit = 1000;
        MatrixOp op;

        public MatrixOperator(double[][] matrix1, double[][] matrix2, double[][] resultMatrix, MatrixOp op, int startRow, int endRow, int ll) {
            this.op = op;
            this.limit = ll;
            this.matrix1 = matrix1;
            this.matrix2 = matrix2;
            this.resultMatrix = resultMatrix;
            this.startRow = startRow;
            this.endRow = endRow;
        }

        @Override
        protected void compute() {
            try {
                if (this.endRow - this.startRow <= this.limit) {
                    int cols = this.matrix1[0].length;
                    int i = this.startRow;
                    while (i < this.endRow) {
                        int j = 0;
                        while (j < cols) {
                            this.resultMatrix[i][j] = this.op.compute(this.matrix1[i][j], this.matrix2[i][j]);
                            ++j;
                        }
                        ++i;
                    }
                } else {
                    int endRow1;
                    int range = this.endRow - this.startRow;
                    int startRow1 = this.startRow;
                    int startRow2 = endRow1 = this.startRow + range / 2;
                    int endRow2 = this.endRow;
                    MatrixOperator.invokeAll(new MatrixOperator(this.matrix1, this.matrix2, this.resultMatrix, this.op, startRow1, endRow1, this.limit), new MatrixOperator(this.matrix1, this.matrix2, this.resultMatrix, this.op, startRow2, endRow2, this.limit));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    class MatrixSummer
    extends RecursiveAction {
        private static final long serialVersionUID = 1L;
        double[][] orig;
        double[] sums;
        int startRow = -1;
        int endRow = -1;
        int limit = 1000;

        public MatrixSummer(double[][] orig, double[] sums, int startRow, int endRow, int ll) {
            this.limit = ll;
            this.orig = orig;
            this.sums = sums;
            this.startRow = startRow;
            this.endRow = endRow;
        }

        public MatrixSummer(double[][] orig, double[] transpose, int startRow, int endRow) {
            this.orig = orig;
            this.sums = transpose;
            this.startRow = startRow;
            this.endRow = endRow;
        }

        @Override
        protected void compute() {
            try {
                if (this.endRow - this.startRow <= this.limit) {
                    int cols = this.orig[0].length;
                    int row = this.startRow;
                    while (row < this.endRow) {
                        int i = 0;
                        while (i < cols) {
                            int n = row;
                            this.sums[n] = this.sums[n] + this.orig[row][i];
                            ++i;
                        }
                        ++row;
                    }
                } else {
                    int endRow1;
                    int range = this.endRow - this.startRow;
                    int startRow1 = this.startRow;
                    int startRow2 = endRow1 = this.startRow + range / 2;
                    int endRow2 = this.endRow;
                    MatrixSummer.invokeAll(new MatrixSummer(this.orig, this.sums, startRow1, endRow1, this.limit), new MatrixSummer(this.orig, this.sums, startRow2, endRow2, this.limit));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    class MatrixTransposer
    extends RecursiveAction {
        private static final long serialVersionUID = 1L;
        double[][] orig;
        double[][] transpose;
        int startRow = -1;
        int endRow = -1;
        int limit = 1000;

        public MatrixTransposer(double[][] orig, double[][] transpose, int startRow, int endRow, int ll) {
            this.limit = ll;
            this.orig = orig;
            this.transpose = transpose;
            this.startRow = startRow;
            this.endRow = endRow;
        }

        public MatrixTransposer(double[][] orig, double[][] transpose, int startRow, int endRow) {
            this.orig = orig;
            this.transpose = transpose;
            this.startRow = startRow;
            this.endRow = endRow;
        }

        @Override
        protected void compute() {
            try {
                if (this.endRow - this.startRow <= this.limit) {
                    int cols = this.orig[0].length;
                    int i = 0;
                    while (i < cols) {
                        int j = this.startRow;
                        while (j < this.endRow) {
                            this.transpose[i][j] = this.orig[j][i];
                            ++j;
                        }
                        ++i;
                    }
                } else {
                    int endRow1;
                    int range = this.endRow - this.startRow;
                    int startRow1 = this.startRow;
                    int startRow2 = endRow1 = this.startRow + range / 2;
                    int endRow2 = this.endRow;
                    MatrixTransposer.invokeAll(new MatrixTransposer(this.orig, this.transpose, startRow1, endRow1, this.limit), new MatrixTransposer(this.orig, this.transpose, startRow2, endRow2, this.limit));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

