/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import jpos.BaseControl;
import jpos.JposException;
import jpos.loader.JposServiceConnection;
import jpos.loader.JposServiceLoader;
import jpos.services.BaseService;
import jpos.services.EventCallbacks;

public abstract class BaseJposControl
implements BaseControl {
    protected static final int deviceVersion12 = 1002000;
    protected static final int deviceVersion13 = 1003000;
    protected static final int deviceVersion14 = 1004000;
    protected static final int deviceVersion15 = 1005000;
    protected static final int deviceVersion16 = 1006000;
    protected static final int deviceVersion17 = 1007000;
    protected static final int deviceVersion18 = 1008000;
    protected static final int deviceVersion19 = 1009000;
    protected static final int deviceVersion110 = 1010000;
    protected static final int deviceVersion111 = 1011000;
    protected static final int deviceVersion112 = 1012000;
    protected static final int deviceVersion113 = 1013000;
    protected static final int deviceVersion114 = 1014000;
    protected String deviceControlDescription;
    protected int deviceControlVersion;
    protected JposServiceConnection serviceConnection;
    protected int serviceVersion;
    protected boolean bOpen;
    protected BaseService service;

    @Override
    public String getCheckHealthText() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service.getCheckHealthText();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    @Override
    public boolean getClaimed() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service.getClaimed();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    @Override
    public String getDeviceControlDescription() {
        return this.deviceControlDescription;
    }

    @Override
    public int getDeviceControlVersion() {
        return this.deviceControlVersion;
    }

    @Override
    public boolean getDeviceEnabled() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service.getDeviceEnabled();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    @Override
    public void setDeviceEnabled(boolean deviceEnabled) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service.setDeviceEnabled(deviceEnabled);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    @Override
    public String getDeviceServiceDescription() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service.getDeviceServiceDescription();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    @Override
    public int getDeviceServiceVersion() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service.getDeviceServiceVersion();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    @Override
    public boolean getFreezeEvents() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service.getFreezeEvents();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    @Override
    public void setFreezeEvents(boolean freezeEvents) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service.setFreezeEvents(freezeEvents);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    @Override
    public String getPhysicalDeviceDescription() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service.getPhysicalDeviceDescription();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    @Override
    public String getPhysicalDeviceName() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service.getPhysicalDeviceName();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    @Override
    public int getState() {
        int nState = 1;
        if (this.bOpen) {
            try {
                nState = this.service.getState();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return nState;
    }

    @Override
    public void claim(int timeout) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service.claim(timeout);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    @Override
    public synchronized void close() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service.close();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
        try {
            this.serviceConnection.disconnect();
        }
        catch (Exception e) {
            throw new JposException(104, "Unable to free service connection", e);
        }
        finally {
            this.setDeviceService(null, 0);
            this.serviceConnection = null;
            this.service = null;
            this.serviceVersion = 0;
            this.bOpen = false;
        }
    }

    @Override
    public void checkHealth(int level) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service.checkHealth(level);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    @Override
    public void directIO(int command, int[] data, Object object) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service.directIO(command, data, object);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    @Override
    public synchronized void open(String logicalDeviceName) throws JposException {
        if (this.bOpen) {
            throw new JposException(106, "Device Control already open");
        }
        try {
            this.serviceConnection = JposServiceLoader.findService(logicalDeviceName);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(109, "Device profile not found", e);
        }
        try {
            this.serviceConnection.connect();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(104, "Could not connect to service", e);
        }
        try {
            this.service = (BaseService)((Object)this.serviceConnection.getService());
        }
        catch (Exception e) {
            throw new JposException(104, "Could not get service instance", e);
        }
        JposException jposException = null;
        boolean bRealOpenSucceeded = false;
        try {
            EventCallbacks callbacks = this.createEventCallbacks();
            this.service.open(logicalDeviceName, callbacks);
            bRealOpenSucceeded = true;
            this.serviceVersion = this.service.getDeviceServiceVersion();
            this.setDeviceService(this.service, this.serviceVersion);
            this.bOpen = true;
            this.service.setDeviceEnabled(false);
        }
        catch (JposException je) {
            jposException = je;
        }
        catch (Exception e) {
            jposException = new JposException(111, "Unhandled exception from Device Service", e);
        }
        if (!this.bOpen) {
            try {
                this.service.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                this.serviceConnection.disconnect();
            }
            catch (Exception e) {
                // empty catch block
            }
            this.serviceConnection = null;
            this.serviceVersion = 0;
            throw jposException;
        }
    }

    @Override
    public void release() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service.release();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    protected abstract EventCallbacks createEventCallbacks();

    protected abstract void setDeviceService(BaseService var1, int var2) throws JposException;
}

