/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.util.Vector;
import jpos.BaseControl;
import jpos.BaseJposControl;
import jpos.JposConst;
import jpos.JposException;
import jpos.MSRControl114;
import jpos.events.DataEvent;
import jpos.events.DataListener;
import jpos.events.DirectIOEvent;
import jpos.events.DirectIOListener;
import jpos.events.ErrorEvent;
import jpos.events.ErrorListener;
import jpos.events.OutputCompleteEvent;
import jpos.events.StatusUpdateEvent;
import jpos.events.StatusUpdateListener;
import jpos.services.BaseService;
import jpos.services.EventCallbacks;
import jpos.services.MSRService110;
import jpos.services.MSRService111;
import jpos.services.MSRService112;
import jpos.services.MSRService113;
import jpos.services.MSRService114;
import jpos.services.MSRService12;
import jpos.services.MSRService13;
import jpos.services.MSRService14;
import jpos.services.MSRService15;
import jpos.services.MSRService16;
import jpos.services.MSRService17;
import jpos.services.MSRService18;
import jpos.services.MSRService19;

public class MSR
extends BaseJposControl
implements MSRControl114,
JposConst {
    protected MSRService12 service12;
    protected MSRService13 service13;
    protected MSRService14 service14;
    protected MSRService15 service15;
    protected MSRService16 service16;
    protected MSRService17 service17;
    protected MSRService18 service18;
    protected MSRService19 service19;
    protected MSRService110 service110;
    protected MSRService111 service111;
    protected MSRService112 service112;
    protected MSRService113 service113;
    protected MSRService114 service114;
    protected Vector dataListeners;
    protected Vector directIOListeners;
    protected Vector errorListeners;
    protected Vector statusUpdateListeners;

    public MSR() {
        this.deviceControlDescription = "JavaPOS MSR Device Control";
        this.deviceControlVersion = 1014000;
        this.dataListeners = new Vector();
        this.directIOListeners = new Vector();
        this.errorListeners = new Vector();
        this.statusUpdateListeners = new Vector();
    }

    @Override
    public boolean getCapISO() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service12.getCapISO();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    @Override
    public boolean getCapJISOne() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service12.getCapJISOne();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    @Override
    public boolean getCapJISTwo() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service12.getCapJISTwo();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    @Override
    public int getCapPowerReporting() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1003000) {
            throw new JposException(104, "Device Service is not 1.3.0 compliant.");
        }
        try {
            return this.service13.getCapPowerReporting();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    @Override
    public boolean getCapTransmitSentinels() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1005000) {
            throw new JposException(104, "Device Service is not 1.5.0 compliant.");
        }
        try {
            return this.service15.getCapTransmitSentinels();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    @Override
    public boolean getCapStatisticsReporting() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1008000) {
            throw new JposException(104, "Device Service is not 1.8.0 compliant.");
        }
        try {
            return this.service18.getCapStatisticsReporting();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    @Override
    public boolean getCapUpdateStatistics() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1008000) {
            throw new JposException(104, "Device Service is not 1.8.0 compliant.");
        }
        try {
            return this.service18.getCapUpdateStatistics();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    @Override
    public boolean getCapCompareFirmwareVersion() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1009000) {
            throw new JposException(104, "Device Service is not 1.9.0 compliant.");
        }
        try {
            return this.service19.getCapCompareFirmwareVersion();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    @Override
    public boolean getCapUpdateFirmware() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1009000) {
            throw new JposException(104, "Device Service is not 1.9.0 compliant.");
        }
        try {
            return this.service19.getCapUpdateFirmware();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    @Override
    public int getCapWritableTracks() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1010000) {
            throw new JposException(104, "Device Service is not 1.10.0 compliant.");
        }
        try {
            return this.service110.getCapWritableTracks();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    @Override
    public String getCapCardAuthentication() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1012000) {
            throw new JposException(104, "Device Service is not 1.12.0 compliant.");
        }
        try {
            return this.service112.getCapCardAuthentication();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    @Override
    public int getCapDataEncryption() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1012000) {
            throw new JposException(104, "Device Service is not 1.12.0 compliant.");
        }
        try {
            return this.service112.getCapDataEncryption();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    @Override
    public int getCapDeviceAuthentication() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1012000) {
            throw new JposException(104, "Device Service is not 1.12.0 compliant.");
        }
        try {
            return this.service112.getCapDeviceAuthentication();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    @Override
    public boolean getCapTrackDataMasking() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1012000) {
            throw new JposException(104, "Device Service is not 1.12.0 compliant.");
        }
        try {
            return this.service112.getCapTrackDataMasking();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    @Override
    public String getAccountNumber() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service12.getAccountNumber();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    @Override
    public boolean getAutoDisable() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service12.getAutoDisable();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    @Override
    public void setAutoDisable(boolean autoDisable) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service12.setAutoDisable(autoDisable);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    @Override
    public int getDataCount() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service12.getDataCount();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    @Override
    public boolean getDataEventEnabled() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service12.getDataEventEnabled();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    @Override
    public void setDataEventEnabled(boolean dataEventEnabled) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service12.setDataEventEnabled(dataEventEnabled);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    @Override
    public boolean getDecodeData() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service12.getDecodeData();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    @Override
    public void setDecodeData(boolean decodeData) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service12.setDecodeData(decodeData);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    @Override
    public int getErrorReportingType() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service12.getErrorReportingType();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    @Override
    public void setErrorReportingType(int errorReportingType) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service12.setErrorReportingType(errorReportingType);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    @Override
    public String getExpirationDate() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service12.getExpirationDate();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    @Override
    public String getFirstName() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service12.getFirstName();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    @Override
    public String getMiddleInitial() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service12.getMiddleInitial();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    @Override
    public boolean getParseDecodeData() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service12.getParseDecodeData();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    @Override
    public void setParseDecodeData(boolean parseDecodeData) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service12.setParseDecodeData(parseDecodeData);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    @Override
    public String getServiceCode() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service12.getServiceCode();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    @Override
    public String getSuffix() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service12.getSuffix();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    @Override
    public String getSurname() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service12.getSurname();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    @Override
    public String getTitle() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service12.getTitle();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    @Override
    public byte[] getTrack1Data() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service12.getTrack1Data();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    @Override
    public byte[] getTrack1DiscretionaryData() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service12.getTrack1DiscretionaryData();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    @Override
    public byte[] getTrack2Data() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service12.getTrack2Data();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    @Override
    public byte[] getTrack2DiscretionaryData() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service12.getTrack2DiscretionaryData();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    @Override
    public byte[] getTrack3Data() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service12.getTrack3Data();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    @Override
    public int getTracksToRead() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            return this.service12.getTracksToRead();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    @Override
    public void setTracksToRead(int tracksToRead) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service12.setTracksToRead(tracksToRead);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    @Override
    public int getPowerNotify() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1003000) {
            throw new JposException(104, "Device Service is not 1.3.0 compliant.");
        }
        try {
            return this.service13.getPowerNotify();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    @Override
    public void setPowerNotify(int powerNotify) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1003000) {
            throw new JposException(104, "Device Service is not 1.3.0 compliant.");
        }
        try {
            this.service13.setPowerNotify(powerNotify);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    @Override
    public int getPowerState() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1003000) {
            throw new JposException(104, "Device Service is not 1.3.0 compliant.");
        }
        try {
            return this.service13.getPowerState();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    @Override
    public byte[] getTrack4Data() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1005000) {
            throw new JposException(104, "Device Service is not 1.5.0 compliant.");
        }
        try {
            return this.service15.getTrack4Data();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    @Override
    public boolean getTransmitSentinels() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1005000) {
            throw new JposException(104, "Device Service is not 1.5.0 compliant.");
        }
        try {
            return this.service15.getTransmitSentinels();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    @Override
    public void setTransmitSentinels(boolean transmitSentinels) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1005000) {
            throw new JposException(104, "Device Service is not 1.5.0 compliant.");
        }
        try {
            this.service15.setTransmitSentinels(transmitSentinels);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    @Override
    public int getEncodingMaxLength() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1010000) {
            throw new JposException(104, "Device Service is not 1.10.0 compliant.");
        }
        try {
            return this.service110.getEncodingMaxLength();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    @Override
    public int getTracksToWrite() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1010000) {
            throw new JposException(104, "Device Service is not 1.10.0 compliant.");
        }
        try {
            return this.service110.getTracksToWrite();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    @Override
    public void setTracksToWrite(int tracks) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1010000) {
            throw new JposException(104, "Device Service is not 1.10.0 compliant.");
        }
        try {
            this.service110.setTracksToWrite(tracks);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    @Override
    public byte[] getAdditionalSecurityInformation() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1012000) {
            throw new JposException(104, "Device Service is not 1.12.0 compliant.");
        }
        try {
            return this.service112.getAdditionalSecurityInformation();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    @Override
    public byte[] getCardAuthenticationData() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1012000) {
            throw new JposException(104, "Device Service is not 1.12.0 compliant.");
        }
        try {
            return this.service112.getCardAuthenticationData();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    @Override
    public int getCardAuthenticationDataLength() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1012000) {
            throw new JposException(104, "Device Service is not 1.12.0 compliant.");
        }
        try {
            return this.service112.getCardAuthenticationDataLength();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    @Override
    public String getCardPropertyList() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1012000) {
            throw new JposException(104, "Device Service is not 1.12.0 compliant.");
        }
        try {
            return this.service112.getCardPropertyList();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    @Override
    public String getCardType() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1012000) {
            throw new JposException(104, "Device Service is not 1.12.0 compliant.");
        }
        try {
            return this.service112.getCardType();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    @Override
    public String getCardTypeList() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1012000) {
            throw new JposException(104, "Device Service is not 1.12.0 compliant.");
        }
        try {
            return this.service112.getCardTypeList();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    @Override
    public int getDataEncryptionAlgorithm() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1012000) {
            throw new JposException(104, "Device Service is not 1.12.0 compliant.");
        }
        try {
            return this.service112.getDataEncryptionAlgorithm();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    @Override
    public void setDataEncryptionAlgorithm(int encryptAlgorithm) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1012000) {
            throw new JposException(104, "Device Service is not 1.12.0 compliant.");
        }
        try {
            this.service112.setDataEncryptionAlgorithm(encryptAlgorithm);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    @Override
    public boolean getDeviceAuthenticated() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1012000) {
            throw new JposException(104, "Device Service is not 1.12.0 compliant.");
        }
        try {
            return this.service112.getDeviceAuthenticated();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    @Override
    public int getDeviceAuthenticationProtocol() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1012000) {
            throw new JposException(104, "Device Service is not 1.12.0 compliant.");
        }
        try {
            return this.service112.getDeviceAuthenticationProtocol();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    @Override
    public byte[] getTrack1EncryptedData() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1012000) {
            throw new JposException(104, "Device Service is not 1.12.0 compliant.");
        }
        try {
            return this.service112.getTrack1EncryptedData();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    @Override
    public int getTrack1EncryptedDataLength() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1012000) {
            throw new JposException(104, "Device Service is not 1.12.0 compliant.");
        }
        try {
            return this.service112.getTrack1EncryptedDataLength();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    @Override
    public byte[] getTrack2EncryptedData() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1012000) {
            throw new JposException(104, "Device Service is not 1.12.0 compliant.");
        }
        try {
            return this.service112.getTrack2EncryptedData();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    @Override
    public int getTrack2EncryptedDataLength() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1012000) {
            throw new JposException(104, "Device Service is not 1.12.0 compliant.");
        }
        try {
            return this.service112.getTrack2EncryptedDataLength();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    @Override
    public byte[] getTrack3EncryptedData() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1012000) {
            throw new JposException(104, "Device Service is not 1.12.0 compliant.");
        }
        try {
            return this.service112.getTrack3EncryptedData();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    @Override
    public int getTrack3EncryptedDataLength() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1012000) {
            throw new JposException(104, "Device Service is not 1.12.0 compliant.");
        }
        try {
            return this.service112.getTrack3EncryptedDataLength();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    @Override
    public byte[] getTrack4EncryptedData() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1012000) {
            throw new JposException(104, "Device Service is not 1.12.0 compliant.");
        }
        try {
            return this.service112.getTrack4EncryptedData();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    @Override
    public int getTrack4EncryptedDataLength() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1012000) {
            throw new JposException(104, "Device Service is not 1.12.0 compliant.");
        }
        try {
            return this.service112.getTrack4EncryptedDataLength();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    @Override
    public String getWriteCardType() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1012000) {
            throw new JposException(104, "Device Service is not 1.12.0 compliant.");
        }
        try {
            return this.service112.getWriteCardType();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    @Override
    public void setWriteCardType(String cardType) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1012000) {
            throw new JposException(104, "Device Service is not 1.12.0 compliant.");
        }
        try {
            this.service112.setWriteCardType(cardType);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    @Override
    public void clearInput() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        try {
            this.service12.clearInput();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    @Override
    public void resetStatistics(String statisticsBuffer) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1008000) {
            throw new JposException(104, "Device Service is not 1.8.0 compliant.");
        }
        try {
            this.service18.resetStatistics(statisticsBuffer);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    @Override
    public void retrieveStatistics(String[] statisticsBuffer) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1008000) {
            throw new JposException(104, "Device Service is not 1.8.0 compliant.");
        }
        try {
            this.service18.retrieveStatistics(statisticsBuffer);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    @Override
    public void updateStatistics(String statisticsBuffer) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1008000) {
            throw new JposException(104, "Device Service is not 1.8.0 compliant.");
        }
        try {
            this.service18.updateStatistics(statisticsBuffer);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    @Override
    public void compareFirmwareVersion(String firmwareFileName, int[] result) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1009000) {
            throw new JposException(104, "Device Service is not 1.9.0 compliant.");
        }
        try {
            this.service19.compareFirmwareVersion(firmwareFileName, result);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    @Override
    public void updateFirmware(String firmwareFileName) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1009000) {
            throw new JposException(104, "Device Service is not 1.9.0 compliant.");
        }
        try {
            this.service19.updateFirmware(firmwareFileName);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    @Override
    public void clearInputProperties() throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1010000) {
            throw new JposException(104, "Device Service is not 1.10.0 compliant.");
        }
        try {
            this.service110.clearInputProperties();
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    @Override
    public void writeTracks(byte[][] data, int timeout) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1010000) {
            throw new JposException(104, "Device Service is not 1.10.0 compliant.");
        }
        try {
            this.service110.writeTracks(data, timeout);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    @Override
    public void authenticateDevice(byte[] response) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1012000) {
            throw new JposException(104, "Device Service is not 1.12.0 compliant.");
        }
        try {
            this.service112.authenticateDevice(response);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    @Override
    public void deauthenticateDevice(byte[] response) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1012000) {
            throw new JposException(104, "Device Service is not 1.12.0 compliant.");
        }
        try {
            this.service112.deauthenticateDevice(response);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    @Override
    public void retrieveCardProperty(String name, String[] value) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1012000) {
            throw new JposException(104, "Device Service is not 1.12.0 compliant.");
        }
        try {
            this.service112.retrieveCardProperty(name, value);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    @Override
    public void retrieveDeviceAuthenticationData(byte[] challenge) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1012000) {
            throw new JposException(104, "Device Service is not 1.12.0 compliant.");
        }
        try {
            this.service112.retrieveDeviceAuthenticationData(challenge);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    @Override
    public void updateKey(String key, String keyName) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1012000) {
            throw new JposException(104, "Device Service is not 1.12.0 compliant.");
        }
        try {
            this.service112.updateKey(key, keyName);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    @Override
    public void retrieveDeviceAuthenticationData(byte[][] challenge) throws JposException {
        if (!this.bOpen) {
            throw new JposException(101, "Control not opened");
        }
        if (this.serviceVersion < 1013000) {
            throw new JposException(104, "Device Service is not 1.13.0 compliant.");
        }
        try {
            this.service113.retrieveDeviceAuthenticationData(challenge);
        }
        catch (JposException je) {
            throw je;
        }
        catch (Exception e) {
            throw new JposException(111, "Unhandled exception from Device Service", e);
        }
    }

    @Override
    protected EventCallbacks createEventCallbacks() {
        return new MSRCallbacks();
    }

    @Override
    protected void setDeviceService(BaseService service, int nServiceVersion) throws JposException {
        if (service == null) {
            this.service12 = null;
            this.service13 = null;
            this.service14 = null;
            this.service15 = null;
            this.service16 = null;
            this.service17 = null;
            this.service18 = null;
            this.service19 = null;
            this.service110 = null;
            this.service111 = null;
            this.service112 = null;
            this.service113 = null;
            this.service114 = null;
        } else {
            if (this.serviceVersion >= 1002000) {
                try {
                    this.service12 = (MSRService12)service;
                }
                catch (Exception e) {
                    throw new JposException(104, "Service does not fully implement MSRService12 interface", e);
                }
            }
            if (this.serviceVersion >= 1003000) {
                try {
                    this.service13 = (MSRService13)service;
                }
                catch (Exception e) {
                    throw new JposException(104, "Service does not fully implement MSRService13 interface", e);
                }
            }
            if (this.serviceVersion >= 1004000) {
                try {
                    this.service14 = (MSRService14)service;
                }
                catch (Exception e) {
                    throw new JposException(104, "Service does not fully implement MSRService14 interface", e);
                }
            }
            if (this.serviceVersion >= 1005000) {
                try {
                    this.service15 = (MSRService15)service;
                }
                catch (Exception e) {
                    throw new JposException(104, "Service does not fully implement MSRService15 interface", e);
                }
            }
            if (this.serviceVersion >= 1006000) {
                try {
                    this.service16 = (MSRService16)service;
                }
                catch (Exception e) {
                    throw new JposException(104, "Service does not fully implement MSRService16 interface", e);
                }
            }
            if (this.serviceVersion >= 1007000) {
                try {
                    this.service17 = (MSRService17)service;
                }
                catch (Exception e) {
                    throw new JposException(104, "Service does not fully implement MSRService17 interface", e);
                }
            }
            if (this.serviceVersion >= 1008000) {
                try {
                    this.service18 = (MSRService18)service;
                }
                catch (Exception e) {
                    throw new JposException(104, "Service does not fully implement MSRService18 interface", e);
                }
            }
            if (this.serviceVersion >= 1009000) {
                try {
                    this.service19 = (MSRService19)service;
                }
                catch (Exception e) {
                    throw new JposException(104, "Service does not fully implement MSRService19 interface", e);
                }
            }
            if (this.serviceVersion >= 1010000) {
                try {
                    this.service110 = (MSRService110)service;
                }
                catch (Exception e) {
                    throw new JposException(104, "Service does not fully implement MSRService110 interface", e);
                }
            }
            if (this.serviceVersion >= 1011000) {
                try {
                    this.service111 = (MSRService111)service;
                }
                catch (Exception e) {
                    throw new JposException(104, "Service does not fully implement MSRService111 interface", e);
                }
            }
            if (this.serviceVersion >= 1012000) {
                try {
                    this.service112 = (MSRService112)service;
                }
                catch (Exception e) {
                    throw new JposException(104, "Service does not fully implement MSRService112 interface", e);
                }
            }
            if (this.serviceVersion >= 1013000) {
                try {
                    this.service113 = (MSRService113)service;
                }
                catch (Exception e) {
                    throw new JposException(104, "Service does not fully implement MSRService113 interface", e);
                }
            }
            if (this.serviceVersion >= 1014000) {
                try {
                    this.service114 = (MSRService114)service;
                }
                catch (Exception e) {
                    throw new JposException(104, "Service does not fully implement MSRService114 interface", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDataListener(DataListener l) {
        Vector vector = this.dataListeners;
        synchronized (vector) {
            this.dataListeners.addElement(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDataListener(DataListener l) {
        Vector vector = this.dataListeners;
        synchronized (vector) {
            this.dataListeners.removeElement(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDirectIOListener(DirectIOListener l) {
        Vector vector = this.directIOListeners;
        synchronized (vector) {
            this.directIOListeners.addElement(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDirectIOListener(DirectIOListener l) {
        Vector vector = this.directIOListeners;
        synchronized (vector) {
            this.directIOListeners.removeElement(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addErrorListener(ErrorListener l) {
        Vector vector = this.errorListeners;
        synchronized (vector) {
            this.errorListeners.addElement(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeErrorListener(ErrorListener l) {
        Vector vector = this.errorListeners;
        synchronized (vector) {
            this.errorListeners.removeElement(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addStatusUpdateListener(StatusUpdateListener l) {
        Vector vector = this.statusUpdateListeners;
        synchronized (vector) {
            this.statusUpdateListeners.addElement(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeStatusUpdateListener(StatusUpdateListener l) {
        Vector vector = this.statusUpdateListeners;
        synchronized (vector) {
            this.statusUpdateListeners.removeElement(l);
        }
    }

    protected class MSRCallbacks
    implements EventCallbacks {
        protected MSRCallbacks() {
        }

        @Override
        public BaseControl getEventSource() {
            return MSR.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void fireDataEvent(DataEvent e) {
            Vector vector = MSR.this.dataListeners;
            synchronized (vector) {
                for (int x = 0; x < MSR.this.dataListeners.size(); ++x) {
                    ((DataListener)MSR.this.dataListeners.elementAt(x)).dataOccurred(e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void fireDirectIOEvent(DirectIOEvent e) {
            Vector vector = MSR.this.directIOListeners;
            synchronized (vector) {
                for (int x = 0; x < MSR.this.directIOListeners.size(); ++x) {
                    ((DirectIOListener)MSR.this.directIOListeners.elementAt(x)).directIOOccurred(e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void fireErrorEvent(ErrorEvent e) {
            Vector vector = MSR.this.errorListeners;
            synchronized (vector) {
                for (int x = 0; x < MSR.this.errorListeners.size(); ++x) {
                    ((ErrorListener)MSR.this.errorListeners.elementAt(x)).errorOccurred(e);
                }
            }
        }

        @Override
        public void fireOutputCompleteEvent(OutputCompleteEvent e) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void fireStatusUpdateEvent(StatusUpdateEvent e) {
            Vector vector = MSR.this.statusUpdateListeners;
            synchronized (vector) {
                for (int x = 0; x < MSR.this.statusUpdateListeners.size(); ++x) {
                    ((StatusUpdateListener)MSR.this.statusUpdateListeners.elementAt(x)).statusUpdateOccurred(e);
                }
            }
        }
    }
}

