/*
 * Decompiled with CFR 0.152.
 */
package jpos.config.simple.xml;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.text.DateFormat;
import java.util.Date;
import java.util.Enumeration;
import jpos.config.JposEntry;
import jpos.config.Version;
import jpos.config.simple.AbstractRegPopulator;
import jpos.config.simple.xml.XmlRegPopulator;
import jpos.util.JposEntryUtility;
import jpos.util.tracing.Tracer;
import jpos.util.tracing.TracerFactory;
import org.apache.xerces.dom.DOMImplementationImpl;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;

public abstract class AbstractXercesRegPopulator
extends AbstractRegPopulator
implements XmlRegPopulator {
    protected String xmlFileName = "jpos.xml";
    protected DOMParser domParser = new DOMParser();
    private Tracer tracer = TracerFactory.getInstance().createTracer("AbstractXercesRegPopulator");
    public static final String DTD_FILE_PATH = "jpos" + File.separator + "res";
    public static final String DTD_FILE_NAME = DTD_FILE_PATH + File.separator + "jcl.dtd";

    public AbstractXercesRegPopulator(String s) {
        super(s);
    }

    @Override
    public void save(Enumeration entries) throws Exception {
        if (this.isPopulatorFileDefined()) {
            this.convertJposEntriesToXml(entries, this.getPopulatorFileOS());
        } else {
            this.convertJposEntriesToXml(entries, new FileOutputStream(this.getDefaultXmlFileName()));
        }
    }

    @Override
    public void save(Enumeration entries, String xmlFileName) throws Exception {
        File xmlFile = new File(xmlFileName);
        FileOutputStream fos = new FileOutputStream(xmlFile);
        this.convertJposEntriesToXml(entries, fos);
        fos.close();
    }

    @Override
    public URL getEntriesURL() {
        URL url = null;
        if (this.getPopulatorFileURL() != null && !this.getPopulatorFileURL().equals("")) {
            try {
                url = new URL(this.getPopulatorFileURL());
            }
            catch (Exception e) {
                this.tracer.println("getEntriesURL: Exception.message=" + e.getMessage());
            }
        } else {
            url = this.createURLFromFile(new File(this.getPopulatorFileName()));
        }
        this.tracer.println("getPopulatorFileURL()=" + this.getPopulatorFileURL());
        this.tracer.println("getPopulatorFileName()=" + this.getPopulatorFileName());
        return url;
    }

    protected Tracer getTracer() {
        return this.tracer;
    }

    protected String getDefaultXmlFileName() {
        return this.xmlFileName;
    }

    protected void convertJposEntriesToXml(Enumeration entries, OutputStream os) throws Exception {
        Document document = this.getParser().getDocument();
        this.serializeDocument(document, entries, os);
    }

    protected DOMParser getParser() {
        return this.domParser;
    }

    protected void serializeDocument(Document document, Enumeration entries, OutputStream os) throws Exception {
        Document newDoc = this.createEmptyDocument();
        this.insertJposEntriesInDoc(newDoc, entries);
        this.insertDateSavedComment(newDoc);
        OutputFormat outFormat = new OutputFormat("xml", "UTF-8", true);
        outFormat.setStandalone(false);
        outFormat.setIndenting(true);
        outFormat.setIndent(4);
        outFormat.setPreserveSpace(true);
        outFormat.setLineWidth(0);
        this.insertDTDInfo(newDoc, outFormat);
        PrintWriter outWriter = null;
        try {
            outWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter(os, "UTF-8")));
        }
        catch (UnsupportedEncodingException ex) {
            this.tracer.println("Error making PrintWriter: UnsupportedEncodingException.message = " + ex.getMessage());
        }
        if (outWriter != null) {
            XMLSerializer xmlSerializer = new XMLSerializer((Writer)outWriter, outFormat);
            xmlSerializer.serialize(newDoc);
        }
    }

    protected String getDoctypeValue() {
        return "jpos/res/jcl.dtd";
    }

    protected void insertDTDInfo(Document doc, OutputFormat outFormat) throws Exception {
        String publicId = OutputFormat.whichDoctypePublic((Document)doc);
        String systemId = OutputFormat.whichDoctypeSystem((Document)doc);
        outFormat.setDoctype("JposEntries", this.getDoctypeValue());
    }

    protected Document createEmptyDocument() {
        DOMImplementationImpl domImpImpl = (DOMImplementationImpl)DOMImplementationImpl.getDOMImplementation();
        DocumentType docType = domImpImpl.createDocumentType("JposEntries", "-//JavaPOS//DTD//EN", this.getDoctypeValue());
        Document doc = domImpImpl.createDocument(null, "JposEntries", docType);
        return doc;
    }

    protected void insertDateSavedComment(Document document) throws Exception {
        String dateString = DateFormat.getInstance().format(new Date(System.currentTimeMillis()));
        String commentString = "Saved by JavaPOS jpos.config/loader (JCL) version " + Version.getVersionString() + " on " + dateString;
        Comment comment = document.createComment(commentString);
        document.getDocumentElement().insertBefore(comment, document.getDocumentElement().getFirstChild());
        document.getDocumentElement().insertBefore(document.createTextNode("\n"), comment);
        document.getDocumentElement().appendChild(document.createTextNode("\n"));
    }

    protected void appendCreationElement(Document doc, Element jposEntryElement, JposEntry jposEntry) {
        jposEntryElement.appendChild(doc.createTextNode("        "));
        Element creationElement = doc.createElement("creation");
        Attr factoryClassAttr = doc.createAttribute("factoryClass");
        Attr serviceClassAttr = doc.createAttribute("serviceClass");
        factoryClassAttr.setValue((String)jposEntry.getPropertyValue("serviceInstanceFactoryClass"));
        serviceClassAttr.setValue((String)jposEntry.getPropertyValue("serviceClass"));
        creationElement.setAttributeNode(factoryClassAttr);
        creationElement.setAttributeNode(serviceClassAttr);
        jposEntryElement.appendChild(creationElement);
        jposEntryElement.appendChild(doc.createTextNode("\n"));
    }

    protected void appendVendorElement(Document doc, Element jposEntryElement, JposEntry jposEntry) {
        jposEntryElement.appendChild(doc.createTextNode("        "));
        Element vendorElement = doc.createElement("vendor");
        Attr nameAttr = doc.createAttribute("name");
        Attr urlAttr = doc.createAttribute("url");
        nameAttr.setValue((String)jposEntry.getPropertyValue("vendorName"));
        urlAttr.setValue((String)jposEntry.getPropertyValue("vendorURL"));
        vendorElement.setAttributeNode(nameAttr);
        vendorElement.setAttributeNode(urlAttr);
        jposEntryElement.appendChild(vendorElement);
        jposEntryElement.appendChild(doc.createTextNode("\n"));
    }

    protected void appendJposElement(Document doc, Element jposEntryElement, JposEntry jposEntry) {
        jposEntryElement.appendChild(doc.createTextNode("        "));
        Element jposElement = doc.createElement("jpos");
        Attr versionAttr = doc.createAttribute("version");
        Attr categoryAttr = doc.createAttribute("category");
        versionAttr.setValue((String)jposEntry.getPropertyValue("jposVersion"));
        categoryAttr.setValue((String)jposEntry.getPropertyValue("deviceCategory"));
        jposElement.setAttributeNode(versionAttr);
        jposElement.setAttributeNode(categoryAttr);
        jposEntryElement.appendChild(jposElement);
        jposEntryElement.appendChild(doc.createTextNode("\n"));
    }

    protected void appendProductElement(Document doc, Element jposEntryElement, JposEntry jposEntry) {
        jposEntryElement.appendChild(doc.createTextNode("        "));
        Element productElement = doc.createElement("product");
        Attr nameAttr = doc.createAttribute("name");
        Attr descriptionAttr = doc.createAttribute("description");
        Attr urlAttr = doc.createAttribute("url");
        nameAttr.setValue((String)jposEntry.getPropertyValue("productName"));
        descriptionAttr.setValue((String)jposEntry.getPropertyValue("productDescription"));
        urlAttr.setValue((String)jposEntry.getPropertyValue("productURL"));
        productElement.setAttributeNode(nameAttr);
        productElement.setAttributeNode(descriptionAttr);
        productElement.setAttributeNode(urlAttr);
        jposEntryElement.appendChild(productElement);
        jposEntryElement.appendChild(doc.createTextNode("\n"));
    }

    protected void appendPropElement(Document doc, Element jposEntryElement, String propName, Object propValue) {
        jposEntryElement.appendChild(doc.createTextNode("        "));
        Element propElement = doc.createElement("prop");
        Attr nameAttr = doc.createAttribute("name");
        Attr valueAttr = doc.createAttribute("value");
        Attr typeAttr = doc.createAttribute("type");
        nameAttr.setValue(propName);
        valueAttr.setValue(propValue.toString());
        typeAttr.setValue(JposEntryUtility.shortClassName(propValue.getClass()));
        propElement.setAttributeNode(nameAttr);
        propElement.setAttributeNode(valueAttr);
        propElement.setAttributeNode(typeAttr);
        jposEntryElement.appendChild(propElement);
        jposEntryElement.appendChild(doc.createTextNode("\n"));
    }

    protected void appendPropElements(Document doc, Element jposEntryElement, JposEntry jposEntry) {
        jposEntryElement.appendChild(doc.createTextNode("\n        "));
        String comment = "Other non JavaPOS required property (mostly vendor properties and bus specific properties i.e. RS232 )";
        jposEntryElement.appendChild(doc.createComment(comment));
        jposEntryElement.appendChild(doc.createTextNode("\n"));
        Enumeration props = jposEntry.getPropertyNames();
        while (props.hasMoreElements()) {
            String propName = (String)props.nextElement();
            if (JposEntryUtility.isRequiredPropName(propName)) continue;
            this.appendPropElement(doc, jposEntryElement, propName, jposEntry.getPropertyValue(propName));
        }
    }

    protected void insertJposEntryInDoc(Document doc, Element jposEntryElement, JposEntry jposEntry) {
        this.appendCreationElement(doc, jposEntryElement, jposEntry);
        this.appendVendorElement(doc, jposEntryElement, jposEntry);
        this.appendJposElement(doc, jposEntryElement, jposEntry);
        this.appendProductElement(doc, jposEntryElement, jposEntry);
        this.appendPropElements(doc, jposEntryElement, jposEntry);
        doc.getDocumentElement().appendChild(doc.createTextNode("\n    "));
        doc.getDocumentElement().appendChild(jposEntryElement);
        doc.getDocumentElement().appendChild(doc.createTextNode("\n    "));
    }

    protected void insertJposEntriesInDoc(Document doc, Enumeration entries) {
        while (entries.hasMoreElements()) {
            JposEntry jposEntry = (JposEntry)entries.nextElement();
            if (!JposEntryUtility.isValidJposEntry(jposEntry)) continue;
            doc.getDocumentElement().appendChild(doc.createTextNode("\n    "));
            Element jposEntryElement = doc.createElement("JposEntry");
            Attr logicalNameAttr = doc.createAttribute("logicalName");
            logicalNameAttr.setValue((String)jposEntry.getPropertyValue("logicalName"));
            jposEntryElement.setAttributeNode(logicalNameAttr);
            jposEntryElement.appendChild(doc.createTextNode("\n"));
            this.insertJposEntryInDoc(doc, jposEntryElement, jposEntry);
        }
    }
}

