/*
 * Decompiled with CFR 0.152.
 */
package jpos.loader;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public final class Version {
    private static final String JCL_VERSION_STRING = Version.getImplementationVersion();

    public static void main(String[] args) {
        System.out.println("JavaPOS jpos.config/loader (JCL) version " + JCL_VERSION_STRING);
    }

    public static String getVersionString() {
        return JCL_VERSION_STRING;
    }

    private static final String getImplementationVersion() {
        try {
            String classContainer = Version.class.getProtectionDomain().getCodeSource().getLocation().toString();
            Manifest manifest = Version.readManifest(classContainer);
            Attributes.Name keyName = new Attributes.Name("Implementation-Version");
            Attributes mainAttributes = manifest.getMainAttributes();
            if (mainAttributes == null || !mainAttributes.containsKey(keyName)) {
                return "version_determination_failed";
            }
            return mainAttributes.getValue(keyName);
        }
        catch (Exception e) {
            return "version_determination_failed";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Manifest readManifest(String classContainer) throws IOException {
        InputStream manifestIn;
        URL manifestUrl = new URL("jar:" + classContainer + "!/META-INF/MANIFEST.MF");
        try {
            manifestIn = manifestUrl.openStream();
        }
        catch (IOException ioe) {
            try {
                manifestIn = new URL(classContainer + "/META-INF/MANIFEST.MF").openStream();
            }
            catch (IOException ioeForFileAccess) {
                throw ioe;
            }
        }
        try {
            Manifest manifest = new Manifest(manifestIn);
            return manifest;
        }
        finally {
            try {
                manifestIn.close();
            }
            catch (IOException ioe) {}
        }
    }
}

