/*
 * Decompiled with CFR 0.152.
 */
package jpos.loader.simple;

import jpos.JposException;
import jpos.config.DefaultCompositeRegPopulator;
import jpos.config.JposEntry;
import jpos.config.JposEntryRegistry;
import jpos.config.JposRegPopulator;
import jpos.config.simple.SimpleEntryRegistry;
import jpos.config.simple.SimpleRegPopulator;
import jpos.loader.JposServiceConnection;
import jpos.loader.JposServiceManager;
import jpos.loader.simple.SimpleServiceConnection;
import jpos.profile.DefaultProfileRegistry;
import jpos.profile.Profile;
import jpos.profile.ProfileException;
import jpos.profile.ProfileFactory;
import jpos.profile.ProfileRegistry;
import jpos.profile.XercesProfileFactory;
import jpos.util.DefaultProperties;
import jpos.util.JposProperties;
import jpos.util.tracing.Tracer;
import jpos.util.tracing.TracerFactory;

public class SimpleServiceManager
implements JposServiceManager {
    private JposRegPopulator regPopulator = null;
    private SimpleEntryRegistry entryRegistry = null;
    private ProfileRegistry profileRegistry = null;
    private ProfileFactory profileFactory = null;
    private JposProperties jposProperties = new DefaultProperties();
    private Tracer tracer = TracerFactory.getInstance().createTracer("SimpleServiceManager");

    public SimpleServiceManager() {
        this.getProperties().loadJposProperties();
        this.init();
    }

    public SimpleServiceManager(JposProperties properties) {
        this.jposProperties = properties;
        this.init();
    }

    private void init() {
        this.initEntryRegistry();
    }

    private void initEntryRegistry() {
        this.initRegPopulator();
        this.entryRegistry = new SimpleEntryRegistry(this.regPopulator);
    }

    private void initRegPopulator() {
        JposProperties properties = this.getProperties();
        if (properties.isPropertyDefined("jpos.config.regPopulatorClass")) {
            String regPopulatorClassName = properties.getPropertyString("jpos.config.regPopulatorClass");
            try {
                Class<?> regPopulatorClass = Class.forName(regPopulatorClassName);
                this.regPopulator = (JposRegPopulator)regPopulatorClass.newInstance();
            }
            catch (Exception e) {
                this.tracer.println("Could not create populator by name: " + regPopulatorClassName + " Exception.message= " + e.getMessage());
                this.regPopulator = new SimpleRegPopulator();
            }
        } else {
            this.regPopulator = properties.hasMultiProperty("jpos.config.populator.class") ? new DefaultCompositeRegPopulator() : new SimpleRegPopulator();
        }
    }

    private ProfileFactory getProfileFactory() {
        if (this.profileFactory == null) {
            this.profileFactory = new XercesProfileFactory();
        }
        return this.profileFactory;
    }

    @Override
    public JposEntryRegistry getEntryRegistry() {
        return this.entryRegistry;
    }

    @Override
    public JposProperties getProperties() {
        return this.jposProperties;
    }

    @Override
    public JposRegPopulator getRegPopulator() {
        return this.regPopulator;
    }

    @Override
    public JposServiceConnection createConnection(String logicalName) throws JposException {
        SimpleServiceConnection sc = null;
        try {
            JposEntry jposEntry = this.entryRegistry.getJposEntry(logicalName);
            if (jposEntry == null) {
                throw new JposException(109, "Service does not exist in loaded JCL registry");
            }
            String siFactoryClassName = (String)jposEntry.getPropertyValue("serviceInstanceFactoryClass");
            sc = new SimpleServiceConnection(logicalName, jposEntry, siFactoryClassName);
        }
        catch (JposException je) {
            this.tracer.println("createConnection: JposException.msg=" + je.getMessage());
            throw je;
        }
        catch (Exception e) {
            this.tracer.println("createConnection: Exception.msg=" + e.getMessage());
            throw new JposException(104, "Could not find service");
        }
        return sc;
    }

    @Override
    public ProfileRegistry getProfileRegistry() {
        if (this.profileRegistry == null) {
            this.profileRegistry = new DefaultProfileRegistry();
        }
        return this.profileRegistry;
    }

    @Override
    public Profile loadProfile(String xmlProfileFileName) throws ProfileException {
        Profile profile = this.getProfileFactory().createProfile(xmlProfileFileName);
        if (profile != null) {
            this.profileRegistry.addProfile(profile);
        }
        return profile;
    }

    @Override
    public void reloadEntryRegistry() {
        this.getProperties().loadJposProperties();
        this.initEntryRegistry();
        this.getEntryRegistry().load();
        this.tracer.println("Sucessfully reloaded registry");
    }
}

