/*
 * Decompiled with CFR 0.152.
 */
package jpos.util;

import jpos.util.DefaultProperties;
import jpos.util.TracerOutput;

public class Tracer {
    private boolean tracerOn = false;
    private TracerOutput onTracerOutput = new DefaultTracerOutput();
    private TracerOutput offTracerOutput = new TracerOutput(){

        @Override
        public void println(String s) {
        }

        @Override
        public void print(String s) {
        }
    };
    private static Tracer instance = null;

    private Tracer() {
    }

    public static Tracer getInstance() {
        if (instance == null) {
            instance = new Tracer();
            instance.init();
        }
        return instance;
    }

    public void println(String s) {
        this.getTracerOutput().println(s);
    }

    public void print(String s) {
        this.getTracerOutput().print(s);
    }

    public void setOn(boolean b) {
        this.tracerOn = b;
    }

    public boolean isOn() {
        return this.tracerOn;
    }

    private void init() {
        DefaultProperties props = new DefaultProperties();
        props.loadJposProperties();
        if (!props.isPropertyDefined("jpos.util.tracing")) {
            this.setOn(false);
        } else {
            String tracingPropValue = props.getPropertyString("jpos.util.tracing");
            if (tracingPropValue.equalsIgnoreCase("ON") || tracingPropValue.equalsIgnoreCase("TRUE")) {
                this.setOn(true);
            }
        }
    }

    private TracerOutput getTracerOutput() {
        return this.isOn() ? this.onTracerOutput : this.offTracerOutput;
    }

    static class DefaultTracerOutput
    implements TracerOutput {
        @Override
        public void println(String s) {
            System.err.println(s);
        }

        @Override
        public void print(String s) {
            System.err.print(s);
        }
    }
}

