/*
 * Decompiled with CFR 0.152.
 */
package jpos.util.tracing;

import java.io.PrintStream;
import jpos.util.DefaultProperties;
import jpos.util.tracing.TracerOutput;

public class Tracer {
    private boolean tracerOn = false;
    private String tracerName = "";
    private boolean appendName = true;
    private TracerOutput customTracerOutput = null;
    private TracerOutput onTracerOutput = new DefaultTracerOutput();
    private TracerOutput offTracerOutput = new TracerOutput(){

        @Override
        public void close() {
        }

        @Override
        public String getPrefix() {
            return "";
        }

        @Override
        public void print(Exception e) {
        }

        @Override
        public void println(String s) {
        }

        @Override
        public void print(String s) {
        }

        @Override
        public void flush() {
        }
    };
    private static Tracer instance = null;

    protected Tracer() {
        this.appendName = false;
    }

    Tracer(String name) {
        if (name == null || name.equals("")) {
            this.appendName = false;
            this.tracerName = "";
            this.onTracerOutput = new DefaultTracerOutput();
        } else {
            this.appendName = true;
            this.onTracerOutput = new DefaultTracerOutput("[" + name + "]");
            this.tracerName = name;
        }
    }

    public static Tracer getInstance() {
        if (instance == null) {
            instance = new Tracer();
            instance.init();
        }
        return instance;
    }

    public void println(String s) {
        this.getTracerOutput().println(s);
    }

    public void println(Object obj) {
        this.getTracerOutput().println(obj.toString());
    }

    public void print(String s) {
        this.getTracerOutput().print(s);
    }

    public void print(Object obj) {
        this.getTracerOutput().print(obj.toString());
    }

    public void print(Exception e) {
        this.getTracerOutput().print(e);
    }

    public void flush() {
        this.getTracerOutput().flush();
    }

    public void setOn(boolean b) {
        this.tracerOn = b;
    }

    public boolean isOn() {
        return this.tracerOn;
    }

    public String getName() {
        return this.tracerName;
    }

    public void setAppendName(boolean b) {
        this.appendName = b;
    }

    public boolean isAppendName() {
        return this.appendName;
    }

    private void init() {
        DefaultProperties props = new DefaultProperties();
        props.loadJposProperties();
        if (!props.isPropertyDefined("jpos.util.tracing")) {
            this.setOn(false);
        } else {
            String tracingPropValue = props.getPropertyString("jpos.util.tracing");
            if (tracingPropValue.equalsIgnoreCase("ON") || tracingPropValue.equalsIgnoreCase("TRUE")) {
                this.setOn(true);
            }
        }
    }

    private TracerOutput getTracerOutput() {
        if (this.customTracerOutput != null) {
            return this.customTracerOutput;
        }
        return this.isOn() ? this.onTracerOutput : this.offTracerOutput;
    }

    void setTracerOutput(TracerOutput tracerOutput) {
        this.tracerOn = true;
        this.customTracerOutput = tracerOutput;
    }

    class DefaultTracerOutput
    implements TracerOutput {
        protected String prefix = "";
        protected PrintStream printStream = System.err;

        public DefaultTracerOutput() {
            this.prefix = "";
            Tracer.this.appendName = false;
        }

        public DefaultTracerOutput(String s) {
            if (s == null) {
                this.prefix = "";
            } else if (s.equals("")) {
                this.prefix = "";
            } else {
                this.prefix = s;
                Tracer.this.appendName = true;
            }
        }

        public DefaultTracerOutput(String s, PrintStream pStream) {
            this(s);
            this.printStream = pStream;
        }

        @Override
        public String getPrefix() {
            return this.prefix;
        }

        @Override
        public void close() {
            this.getPrintStream().close();
        }

        @Override
        public void println(String s) {
            this.getPrintStream().println((Tracer.this.appendName ? this.prefix : "") + s);
        }

        @Override
        public void print(String s) {
            this.getPrintStream().print((Tracer.this.appendName ? this.prefix : "") + s);
        }

        @Override
        public void print(Exception e) {
            if (Tracer.this.appendName) {
                System.err.println("<" + this.prefix + ">");
            }
            e.printStackTrace(this.getPrintStream());
            if (Tracer.this.appendName) {
                System.err.println("</" + this.prefix + ">");
            }
        }

        @Override
        public void flush() {
            this.getPrintStream().flush();
        }

        protected PrintStream getPrintStream() {
            return this.printStream;
        }

        protected void setPrintStream(PrintStream pStream) {
            this.printStream = pStream;
        }
    }
}

