/*
 * Decompiled with CFR 0.152.
 */
package com.jmatio.io;

import com.jmatio.io.MatTag;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public class OSArrayTag
extends MatTag {
    private ByteBuffer data;
    private int padding;

    public OSArrayTag(int type, byte[] data) {
        this(type, ByteBuffer.wrap(data));
    }

    public OSArrayTag(int type, ByteBuffer data) {
        super(type, data.limit());
        this.data = data;
        data.rewind();
        this.padding = this.getPadding(data.limit(), false);
    }

    public void writeTo(DataOutputStream os) throws IOException {
        os.writeInt(this.type);
        os.writeInt(this.size);
        int maxBuffSize = 1024;
        int writeBuffSize = this.data.remaining() < maxBuffSize ? this.data.remaining() : maxBuffSize;
        byte[] tmp = new byte[writeBuffSize];
        while (this.data.remaining() > 0) {
            int length = this.data.remaining() > tmp.length ? tmp.length : this.data.remaining();
            this.data.get(tmp, 0, length);
            os.write(tmp, 0, length);
        }
        if (this.padding > 0) {
            os.write(new byte[this.padding]);
        }
    }
}

