/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.object.h5;

import java.util.List;
import java.util.Vector;
import ncsa.hdf.hdf5lib.H5;
import ncsa.hdf.hdf5lib.HDF5Constants;
import ncsa.hdf.hdf5lib.HDFNativeData;
import ncsa.hdf.hdf5lib.exceptions.HDF5Exception;
import ncsa.hdf.object.Attribute;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.Group;
import ncsa.hdf.object.HObject;
import ncsa.hdf.object.h5.H5File;

public class H5Group
extends Group {
    public static final long serialVersionUID = 240L;
    protected List attributeList;

    public H5Group(FileFormat fileFormat, String string, String string2, Group group) {
        this(fileFormat, string, string2, group, null);
    }

    public H5Group(FileFormat fileFormat, String string, String string2, Group group, long[] lArray) {
        super(fileFormat, string, string2, group, lArray);
        if (lArray == null && fileFormat != null) {
            try {
                byte[] byArray = H5.H5Rcreate((int)fileFormat.getFID(), (String)this.getFullName(), (int)HDF5Constants.H5R_OBJECT, (int)-1);
                this.oid = new long[1];
                this.oid[0] = HDFNativeData.byteToLong((byte[])byArray, (int)0);
            }
            catch (Exception exception) {
                this.oid = new long[1];
                this.oid[0] = 0L;
            }
        }
        int n = this.open();
        try {
            this.hasAttribute = H5.H5Aget_num_attrs((int)n) > 0;
            long[] lArray2 = new long[]{0L};
            H5.H5Gget_num_objs((int)n, (long[])lArray2);
            this.nMembersInFile = (int)lArray2[0];
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.close(n);
    }

    public void clear() {
        super.clear();
        if (this.attributeList != null) {
            ((Vector)this.attributeList).setSize(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getMetadata() throws HDF5Exception {
        if (this.attributeList == null) {
            int n = this.open();
            try {
                this.attributeList = H5File.getAttribute(n);
            }
            finally {
                this.close(n);
            }
        }
        return this.attributeList;
    }

    public void writeMetadata(Object object) throws Exception {
        if (!(object instanceof Attribute)) {
            return;
        }
        boolean bl = false;
        Attribute attribute = (Attribute)object;
        String string = attribute.getName();
        if (this.attributeList == null) {
            this.getMetadata();
        } else {
            bl = this.attributeList.contains(attribute);
        }
        this.getFileFormat().writeAttribute((HObject)this, attribute, bl);
        if (!bl) {
            this.attributeList.add(attribute);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMetadata(Object object) throws HDF5Exception {
        if (!(object instanceof Attribute)) {
            return;
        }
        Attribute attribute = (Attribute)object;
        int n = this.open();
        try {
            H5.H5Adelete((int)n, (String)attribute.getName());
            List list = this.getMetadata();
            list.remove(attribute);
        }
        finally {
            this.close(n);
        }
    }

    public int open() {
        int n = -1;
        try {
            n = this.isRoot() ? H5.H5Gopen((int)this.getFID(), (String)"/") : H5.H5Gopen((int)this.getFID(), (String)(this.getPath() + this.getName()));
        }
        catch (HDF5Exception hDF5Exception) {
            n = -1;
        }
        return n;
    }

    public void close(int n) {
        try {
            H5.H5Gclose((int)n);
        }
        catch (HDF5Exception hDF5Exception) {
            // empty catch block
        }
    }

    public static H5Group create(String string, Group group) throws Exception {
        int n;
        H5Group h5Group = null;
        String string2 = null;
        if (string == null) {
            return null;
        }
        H5File h5File = (H5File)group.getFileFormat();
        if (h5File == null) {
            return null;
        }
        if (group == null) {
            group = (Group)h5File.get("/");
        }
        String string3 = "/";
        if (!group.isRoot()) {
            string3 = group.getPath() + group.getName() + "/";
            if (string.endsWith("/")) {
                string = string.substring(0, string.length() - 1);
            }
            if ((n = string.lastIndexOf("/")) >= 0) {
                string = string.substring(n + 1);
            }
        }
        string2 = string3 + string;
        n = H5.H5Gcreate((int)h5File.open(), (String)string2, (int)-1);
        byte[] byArray = H5.H5Rcreate((int)h5File.open(), (String)string2, (int)HDF5Constants.H5R_OBJECT, (int)-1);
        long l = HDFNativeData.byteToLong((byte[])byArray, (int)0);
        long[] lArray = new long[]{l};
        h5Group = new H5Group(h5File, string, string3, group, lArray);
        if (h5Group != null) {
            group.addToMemberList((HObject)h5Group);
        }
        return h5Group;
    }

    public void setName(String string) throws Exception {
        String string2 = this.getPath() + this.getName();
        String string3 = this.getPath() + string;
        string2 = string2.replaceAll("//", "/");
        string3 = string3.replaceAll("//", "/");
        if (string2.equals("/")) {
            throw new HDF5Exception("Can't rename the root group.");
        }
        if (string2.equals(string3)) {
            throw new HDF5Exception("The new name is the same as the current name.");
        }
        H5.H5Gmove((int)this.getFID(), (String)string2, (String)string3);
        super.setName(string);
    }

    public void setPath(String string) throws Exception {
        super.setPath(string);
        List list = this.getMemberList();
        if (list == null) {
            return;
        }
        int n = list.size();
        HObject hObject = null;
        for (int i = 0; i < n; ++i) {
            hObject = (HObject)list.get(i);
            hObject.setPath(this.getPath() + this.getName() + "/");
        }
    }
}

