/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.object.h5;

import java.lang.reflect.Array;
import java.util.List;
import java.util.Vector;
import ncsa.hdf.hdf5lib.H5;
import ncsa.hdf.hdf5lib.HDF5Constants;
import ncsa.hdf.hdf5lib.HDFNativeData;
import ncsa.hdf.hdf5lib.exceptions.HDF5Exception;
import ncsa.hdf.object.Attribute;
import ncsa.hdf.object.Dataset;
import ncsa.hdf.object.Datatype;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.Group;
import ncsa.hdf.object.HObject;
import ncsa.hdf.object.ScalarDS;
import ncsa.hdf.object.h5.H5Datatype;
import ncsa.hdf.object.h5.H5File;

public class H5ScalarDS
extends ScalarDS {
    public static final long serialVersionUID = 240L;
    private List attributeList;
    private byte[] paletteRefs;
    private boolean isVLEN;
    private boolean isEnum;
    private boolean isExternal;
    private boolean isNativeDatatype;

    public H5ScalarDS(FileFormat fileFormat, String string, String string2) {
        this(fileFormat, string, string2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public H5ScalarDS(FileFormat fileFormat, String string, String string2, long[] lArray) {
        int n;
        block58: {
            int n2;
            super(fileFormat, string, string2, lArray);
            this.isVLEN = false;
            this.isEnum = false;
            this.isExternal = false;
            this.isNativeDatatype = false;
            this.unsignedConverted = false;
            this.paletteRefs = null;
            if (lArray == null && fileFormat != null) {
                try {
                    byte[] byArray = H5.H5Rcreate((int)fileFormat.getFID(), (String)this.getFullName(), (int)HDF5Constants.H5R_OBJECT, (int)-1);
                    this.oid = new long[1];
                    this.oid[0] = HDFNativeData.byteToLong((byte[])byArray, (int)0);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            n = this.open();
            int n3 = -1;
            int n4 = -1;
            int n5 = 0;
            try {
                this.hasAttribute = H5.H5Aget_num_attrs((int)n) > 0;
                n5 = H5.H5Dget_type((int)n);
                int n6 = H5.H5Tget_class((int)n5);
                this.isText = n6 == HDF5Constants.H5T_STRING;
                this.isVLEN = n6 == HDF5Constants.H5T_VLEN || H5.H5Tis_variable_str((int)n5);
                this.isEnum = n6 == HDF5Constants.H5T_ENUM;
                n3 = H5.H5Aopen_name((int)n, (String)"CLASS");
                n4 = H5.H5Aget_type((int)n3);
                n2 = H5.H5Tget_class((int)n4);
                if (n2 == HDF5Constants.H5T_STRING) {
                    int n7 = H5.H5Tget_size((int)n4);
                    byte[] byArray = new byte[n7];
                    H5.H5Aread((int)n3, (int)n4, (byte[])byArray);
                    String string3 = new String(byArray).trim();
                    this.isImageDisplay = this.isImage = string3.equalsIgnoreCase("IMAGE");
                }
            }
            catch (Exception exception) {
            }
            finally {
                try {
                    H5.H5Tclose((int)n4);
                }
                catch (HDF5Exception hDF5Exception) {}
                try {
                    H5.H5Aclose((int)n3);
                }
                catch (HDF5Exception hDF5Exception) {}
                try {
                    H5.H5Tclose((int)n5);
                }
                catch (HDF5Exception hDF5Exception) {}
            }
            int n8 = -1;
            try {
                n3 = H5.H5Aopen_name((int)n, (String)"IMAGE_MINMAXRANGE");
                if (n3 <= 0) break block58;
                n2 = n4 = H5.H5Aget_type((int)n3);
                n4 = H5.H5Tget_native_type((int)n2);
                try {
                    H5.H5Tclose((int)n2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                n8 = H5.H5Aget_space((int)n3);
                long[] lArray2 = null;
                int n9 = H5.H5Sget_simple_extent_ndims((int)n8);
                if (n9 > 0) {
                    lArray2 = new long[n9];
                    H5.H5Sget_simple_extent_dims((int)n8, (long[])lArray2, null);
                }
                long l = 1L;
                for (int i = 0; i < lArray2.length; ++i) {
                    l *= lArray2[i];
                }
                Object object = H5Datatype.allocateArray(n4, (int)l);
                if (object == null) break block58;
                H5.H5Aread((int)n3, (int)n4, (Object)object);
                double d = 0.0;
                double d2 = 0.0;
                try {
                    d = Double.valueOf(Array.get(object, 0).toString());
                    d2 = Double.valueOf(Array.get(object, 1).toString());
                }
                catch (Exception exception) {
                    d2 = 0.0;
                    d = 0.0;
                }
                if (d2 > d) {
                    this.imageDataRange = new double[2];
                    this.imageDataRange[0] = d;
                    this.imageDataRange[1] = d2;
                }
            }
            catch (Exception exception) {
            }
            finally {
                try {
                    H5.H5Tclose((int)n4);
                }
                catch (HDF5Exception hDF5Exception) {}
                try {
                    H5.H5Sclose((int)n8);
                }
                catch (HDF5Exception hDF5Exception) {}
                try {
                    H5.H5Aclose((int)n3);
                }
                catch (HDF5Exception hDF5Exception) {}
            }
        }
        this.close(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        if (this.rank > 0) {
            this.resetSelection();
            return;
        }
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        n = this.open();
        this.paletteRefs = this.getPaletteRefs(n);
        int n4 = -1;
        try {
            n4 = H5.H5Dget_create_plist((int)n);
            int n5 = H5.H5Pget_external_count((int)n4);
            this.isExternal = n5 > 1;
        }
        catch (Exception exception) {
        }
        finally {
            try {
                H5.H5Pclose((int)n4);
            }
            catch (Exception exception) {}
        }
        try {
            n2 = H5.H5Dget_space((int)n);
            n3 = H5.H5Dget_type((int)n);
            this.rank = H5.H5Sget_simple_extent_ndims((int)n2);
            this.isText = H5.H5Tget_class((int)n3) == HDF5Constants.H5T_STRING;
            this.isUnsigned = H5Datatype.isUnsigned(n3);
            int n6 = 0;
            try {
                n6 = H5.H5Tget_native_type((int)n3);
                this.isNativeDatatype = H5.H5Tequal((int)n3, (int)n6);
            }
            finally {
                try {
                    H5.H5Tclose((int)n6);
                }
                catch (HDF5Exception hDF5Exception) {}
            }
            if (this.rank == 0) {
                this.rank = 1;
                this.dims = new long[1];
                this.dims[0] = 1L;
            } else {
                this.dims = new long[this.rank];
                H5.H5Sget_simple_extent_dims((int)n2, (long[])this.dims, null);
            }
        }
        catch (HDF5Exception hDF5Exception) {
        }
        finally {
            try {
                H5.H5Tclose((int)n3);
            }
            catch (HDF5Exception hDF5Exception) {}
            try {
                H5.H5Sclose((int)n2);
            }
            catch (HDF5Exception hDF5Exception) {}
        }
        if (this.rank >= 3 && this.isImage) {
            this.interlace = -1;
            this.isTrueColor = this.isStringAttributeOf(n, "IMAGE_SUBCLASS", "IMAGE_TRUECOLOR");
            if (this.isTrueColor) {
                this.interlace = 0;
                if (this.isStringAttributeOf(n, "INTERLACE_MODE", "INTERLACE_PLANE")) {
                    this.interlace = 2;
                }
            }
        }
        this.close(n);
        this.startDims = new long[this.rank];
        this.selectedDims = new long[this.rank];
        this.resetSelection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isStringAttributeOf(int n, String string, String string2) {
        boolean bl = false;
        int n2 = -1;
        int n3 = -1;
        try {
            n2 = H5.H5Aopen_name((int)n, (String)string);
            n3 = H5.H5Aget_type((int)n2);
            int n4 = H5.H5Tget_size((int)n3);
            byte[] byArray = new byte[n4];
            H5.H5Aread((int)n2, (int)n3, (byte[])byArray);
            String string3 = new String(byArray).trim();
            bl = string3.equalsIgnoreCase(string2);
        }
        catch (Exception exception) {
        }
        finally {
            try {
                H5.H5Tclose((int)n3);
            }
            catch (HDF5Exception hDF5Exception) {}
            try {
                H5.H5Aclose((int)n2);
            }
            catch (HDF5Exception hDF5Exception) {}
        }
        return bl;
    }

    private void resetSelection() {
        for (int i = 0; i < this.rank; ++i) {
            this.startDims[i] = 0L;
            this.selectedDims[i] = 1L;
            if (this.selectedStride == null) continue;
            this.selectedStride[i] = 1L;
        }
        if (this.interlace == 0) {
            this.selectedDims[2] = 3L;
            this.selectedDims[0] = this.dims[0];
            this.selectedDims[1] = this.dims[1];
            this.selectedIndex[0] = 0;
            this.selectedIndex[1] = 1;
            this.selectedIndex[2] = 2;
        } else if (this.interlace == 2) {
            this.selectedDims[0] = 3L;
            this.selectedDims[1] = this.dims[1];
            this.selectedDims[2] = this.dims[2];
            this.selectedIndex[0] = 1;
            this.selectedIndex[1] = 2;
            this.selectedIndex[2] = 0;
        } else if (this.rank == 1) {
            this.selectedIndex[0] = 0;
            this.selectedDims[0] = this.dims[0];
        } else if (this.rank == 2) {
            this.selectedIndex[0] = 0;
            this.selectedIndex[1] = 1;
            this.selectedDims[0] = this.dims[0];
            this.selectedDims[1] = this.dims[1];
        } else if (this.rank > 2) {
            this.selectedIndex[1] = this.rank - 1;
            this.selectedIndex[0] = this.rank - 2;
            this.selectedIndex[2] = this.rank - 3;
            this.selectedDims[this.selectedIndex[0]] = this.dims[this.selectedIndex[0]];
            this.selectedDims[this.selectedIndex[1]] = this.dims[this.selectedIndex[1]];
        }
        if (this.rank > 1 && this.isText) {
            this.selectedIndex[0] = this.rank - 1;
            this.selectedIndex[1] = 0;
            this.selectedDims[0] = 1L;
            this.selectedDims[this.selectedIndex[0]] = this.dims[this.selectedIndex[0]];
        }
        this.isDataLoaded = false;
    }

    public void clear() {
        super.clear();
        if (this.attributeList != null) {
            ((Vector)this.attributeList).setSize(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dataset copy(Group group, String string, long[] lArray, Object object) throws Exception {
        if (group == null) {
            return null;
        }
        H5ScalarDS h5ScalarDS = null;
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        String string2 = null;
        String string3 = null;
        string3 = group.isRoot() ? "/" : group.getPath() + group.getName() + "/";
        string2 = string3 + string;
        try {
            n = this.open();
            n3 = H5.H5Dget_type((int)n);
            n4 = H5.H5Screate_simple((int)lArray.length, (long[])lArray, null);
            n5 = H5.H5Dget_create_plist((int)n);
            try {
                n2 = H5.H5Dcreate((int)group.getFID(), (String)string2, (int)n3, (int)n4, (int)n5);
            }
            finally {
                try {
                    H5.H5Dclose((int)n2);
                }
                catch (Exception exception) {}
            }
            h5ScalarDS = new H5ScalarDS(group.getFileFormat(), string, string3);
            if (object != null) {
                h5ScalarDS.write(object);
            }
            n2 = h5ScalarDS.open();
            H5File.copyAttributes(n, n2);
        }
        finally {
            try {
                H5.H5Pclose((int)n5);
            }
            catch (Exception exception) {}
            try {
                H5.H5Sclose((int)n4);
            }
            catch (Exception exception) {}
            try {
                H5.H5Tclose((int)n3);
            }
            catch (Exception exception) {}
            try {
                H5.H5Dclose((int)n);
            }
            catch (Exception exception) {}
            try {
                H5.H5Dclose((int)n2);
            }
            catch (Exception exception) {}
        }
        group.addToMemberList((HObject)h5ScalarDS);
        ((ScalarDS)h5ScalarDS).setIsImage(this.isImage);
        return h5ScalarDS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readBytes() throws HDF5Exception {
        byte[] byArray = null;
        if (this.rank <= 0) {
            this.init();
        }
        int n = this.open();
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        try {
            int n5;
            long[] lArray = new long[]{1L};
            for (n5 = 0; n5 < this.selectedDims.length; ++n5) {
                lArray[0] = lArray[0] * this.selectedDims[n5];
            }
            n2 = H5.H5Dget_space((int)n);
            n3 = H5.H5Screate_simple((int)this.rank, (long[])this.selectedDims, null);
            if ((long)this.rank * this.dims[0] > 1L) {
                H5.H5Sselect_hyperslab((int)n2, (int)HDF5Constants.H5S_SELECT_SET, (long[])this.startDims, (long[])this.selectedStride, (long[])this.selectedDims, null);
            }
            n4 = H5.H5Dget_type((int)n);
            n5 = H5.H5Tget_size((int)n4) * (int)lArray[0];
            byArray = new byte[n5];
            H5.H5Dread((int)n, (int)n4, (int)n3, (int)n2, (int)HDF5Constants.H5P_DEFAULT, (byte[])byArray);
        }
        finally {
            try {
                H5.H5Sclose((int)n2);
            }
            catch (Exception exception) {}
            try {
                H5.H5Sclose((int)n3);
            }
            catch (Exception exception) {}
            try {
                H5.H5Tclose((int)n4);
            }
            catch (HDF5Exception hDF5Exception) {}
            this.close(n);
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object read() throws HDF5Exception {
        Object object;
        Object object2 = null;
        int n = -1;
        int n2 = -1;
        int[] nArray = new int[]{-1, -1};
        if (this.rank <= 0) {
            this.init();
        }
        if (this.isExternal) {
            object = this.getFileFormat().getAbsoluteFile().getParent();
            if (object == null) {
                object = ".";
            }
            H5.H5Dchdir_ext((String)object);
        }
        object = new long[]{1L};
        try {
            n = this.open();
            object[0] = this.selectHyperslab(n, nArray);
            if (object[0] == 0L) {
                throw new HDF5Exception("No data to read.\nEither the dataset or the selected subset is empty.");
            }
            try {
                long l = H5.H5Dget_storage_size((int)n);
                if (l <= 0L) {
                    throw new HDF5Exception("Storage space is not allocated.");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            n2 = H5.H5Dget_type((int)n);
            if (!this.isNativeDatatype) {
                int n3 = -1;
                try {
                    n3 = n2;
                    n2 = H5.H5Tget_native_type((int)n3);
                }
                finally {
                    try {
                        H5.H5Tclose((int)n3);
                    }
                    catch (Exception exception) {}
                }
            }
            boolean bl = H5.H5Tequal((int)n2, (int)HDF5Constants.H5T_STD_REF_OBJ);
            object2 = this.originalBuf == null || this.isText || bl || this.originalBuf != null && object[0] != this.nPoints ? H5Datatype.allocateArray(n2, (int)object[0]) : this.originalBuf;
            if (object2 != null) {
                if (this.isVLEN) {
                    H5.H5DreadVL((int)n, (int)n2, (int)nArray[0], (int)nArray[1], (int)HDF5Constants.H5P_DEFAULT, (Object[])object2);
                } else {
                    H5.H5Dread((int)n, (int)n2, (int)nArray[0], (int)nArray[1], (int)HDF5Constants.H5P_DEFAULT, (Object)object2);
                    if (this.isText && this.convertByteToString) {
                        object2 = H5ScalarDS.byteToString((byte[])((byte[])object2), (int)H5.H5Tget_size((int)n2));
                    } else if (bl) {
                        object2 = HDFNativeData.byteToLong((byte[])((byte[])object2));
                    } else if (this.isEnum && this.isEnumConverted()) {
                        object2 = H5Datatype.convertEnumValueToName(n2, object2, null);
                    }
                }
            }
        }
        finally {
            try {
                H5.H5Sclose((int)nArray[0]);
            }
            catch (Exception exception) {}
            try {
                H5.H5Sclose((int)nArray[1]);
            }
            catch (Exception exception) {}
            try {
                H5.H5Tclose((int)n2);
            }
            catch (Exception exception) {}
            this.close(n);
        }
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(Object object) throws HDF5Exception {
        int n = -1;
        int n2 = -1;
        int[] nArray = new int[]{-1, -1};
        Object object2 = null;
        if (object == null) {
            return;
        }
        if (this.isVLEN) {
            throw new HDF5Exception("Writing variable-length data is not supported");
        }
        if (this.isEnum && this.isEnumConverted()) {
            throw new HDF5Exception("Writing converted enum data is not supported");
        }
        long[] lArray = new long[]{1L};
        try {
            int n3;
            n = this.open();
            lArray[0] = this.selectHyperslab(n, nArray);
            n2 = H5.H5Dget_type((int)n);
            if (!this.isNativeDatatype) {
                n3 = -1;
                try {
                    n3 = n2;
                    n2 = H5.H5Tget_native_type((int)n3);
                }
                finally {
                    try {
                        H5.H5Tclose((int)n3);
                    }
                    catch (Exception exception) {}
                }
            }
            this.isText = H5.H5Tget_class((int)n2) == HDF5Constants.H5T_STRING;
            n3 = H5.H5Tequal((int)n2, (int)HDF5Constants.H5T_STD_REF_DSETREG) ? 1 : 0;
            if (n3 == 0) {
                boolean bl;
                int n4 = H5.H5Tget_size((int)n2);
                String string = object.getClass().getName();
                char c = string.charAt(string.lastIndexOf("[") + 1);
                boolean bl2 = bl = n4 == 1 && c == 'S' || n4 == 2 && c == 'I' || n4 == 4 && c == 'J' || this.isUnsigned && this.unsignedConverted;
                object2 = bl ? H5ScalarDS.convertToUnsignedC((Object)object, null) : (this.isText && this.convertByteToString ? (Object)H5ScalarDS.stringToByte((String[])((String[])object), (int)H5.H5Tget_size((int)n2)) : object);
                H5.H5Dwrite((int)n, (int)n2, (int)nArray[0], (int)nArray[1], (int)HDF5Constants.H5P_DEFAULT, (Object)object2);
            }
        }
        finally {
            object2 = null;
            try {
                H5.H5Sclose((int)nArray[0]);
            }
            catch (Exception exception) {}
            try {
                H5.H5Sclose((int)nArray[1]);
            }
            catch (Exception exception) {}
            try {
                H5.H5Tclose((int)n2);
            }
            catch (Exception exception) {}
            this.close(n);
        }
    }

    private long selectHyperslab(int n, int[] nArray) throws HDF5Exception {
        long l = 1L;
        boolean bl = true;
        for (int i = 0; i < this.rank; ++i) {
            l *= this.selectedDims[i];
            if (this.selectedDims[i] >= this.dims[i]) continue;
            bl = false;
        }
        if (bl) {
            nArray[0] = HDF5Constants.H5S_ALL;
            nArray[1] = HDF5Constants.H5S_ALL;
        } else {
            nArray[1] = H5.H5Dget_space((int)n);
            nArray[0] = H5.H5Screate_simple((int)this.rank, (long[])this.selectedDims, null);
            H5.H5Sselect_hyperslab((int)nArray[1], (int)HDF5Constants.H5S_SELECT_SET, (long[])this.startDims, (long[])this.selectedStride, (long[])this.selectedDims, null);
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getMetadata() throws HDF5Exception {
        if (this.rank <= 0) {
            this.init();
        }
        if (this.attributeList != null) {
            return this.attributeList;
        }
        int n = -1;
        int n2 = -1;
        try {
            n = this.open();
            this.attributeList = H5File.getAttribute(n);
            n2 = H5.H5Dget_create_plist((int)n);
            if (H5.H5Pget_layout((int)n2) == HDF5Constants.H5D_CHUNKED) {
                this.chunkSize = new long[this.rank];
                H5.H5Pget_chunk((int)n2, (int)this.rank, (long[])this.chunkSize);
            } else {
                this.chunkSize = null;
            }
            int[] nArray = new int[]{0};
            if (H5.H5Pfill_value_defined((int)n2, (int[])nArray) >= 0 && nArray[0] == HDF5Constants.H5D_FILL_VALUE_USER_DEFINED) {
                int n3 = H5.H5Dget_type((int)n);
                if (!this.isNativeDatatype) {
                    int n4 = -1;
                    try {
                        n4 = n3;
                        n3 = H5.H5Tget_native_type((int)n4);
                    }
                    finally {
                        try {
                            H5.H5Tclose((int)n4);
                        }
                        catch (Exception exception) {}
                    }
                }
                this.fillValue = H5Datatype.allocateArray(n3, 1);
                try {
                    H5.H5Pget_fill_value((int)n2, (int)n3, (Object)this.fillValue);
                }
                catch (Exception exception) {
                    this.fillValue = null;
                }
                finally {
                    try {
                        H5.H5Tclose((int)n3);
                    }
                    catch (Exception exception) {}
                }
            }
            int[] nArray2 = new int[]{0, 0};
            int[] nArray3 = new int[]{2};
            int[] nArray4 = new int[]{0, 0};
            String[] stringArray = new String[]{"", ""};
            int n5 = H5.H5Pget_nfilters((int)n2);
            int n6 = -1;
            this.compression = "";
            for (int i = 0; i < n5; ++i) {
                if (i > 0) {
                    this.compression = this.compression + ", ";
                }
                try {
                    n6 = H5.H5Pget_filter((int)n2, (int)i, (int[])nArray2, (int[])nArray3, (int[])nArray4, (int)120, (String[])stringArray);
                }
                catch (Throwable throwable) {
                    this.compression = this.compression + "ERROR";
                    continue;
                }
                if (n6 == HDF5Constants.H5Z_FILTER_DEFLATE) {
                    this.compression = this.compression + "GZIP: level = " + nArray4[0];
                    continue;
                }
                if (n6 == HDF5Constants.H5Z_FILTER_FLETCHER32) {
                    this.compression = this.compression + "Error detection filter";
                    continue;
                }
                if (n6 == HDF5Constants.H5Z_FILTER_SHUFFLE) {
                    this.compression = this.compression + "SHUFFLE: Nbytes = " + nArray4[0];
                    continue;
                }
                if (n6 != HDF5Constants.H5Z_FILTER_SZIP) continue;
                this.compression = this.compression + "SZIP: Pixels per block = " + nArray4[1];
                int n7 = -1;
                try {
                    n7 = H5.H5Zget_filter_info((int)n6);
                }
                catch (Exception exception) {
                    n7 = -1;
                }
                if (n7 == HDF5Constants.H5Z_FILTER_CONFIG_DECODE_ENABLED) {
                    this.compression = this.compression + ": H5Z_FILTER_CONFIG_DECODE_ENABLED";
                    continue;
                }
                if (n7 != HDF5Constants.H5Z_FILTER_CONFIG_ENCODE_ENABLED && n7 < HDF5Constants.H5Z_FILTER_CONFIG_ENCODE_ENABLED + HDF5Constants.H5Z_FILTER_CONFIG_DECODE_ENABLED) continue;
                this.compression = this.compression + ": H5Z_FILTER_CONFIG_ENCODE_ENABLED";
            }
            if (this.compression.length() == 0) {
                this.compression = "NONE";
            }
            try {
                int[] nArray5 = new int[]{0};
                H5.H5Pget_alloc_time((int)n2, (int[])nArray5);
                this.compression = this.compression + ",         Storage allocation time: ";
                if (nArray5[0] == HDF5Constants.H5D_ALLOC_TIME_EARLY) {
                    this.compression = this.compression + "Early";
                } else if (nArray5[0] == HDF5Constants.H5D_ALLOC_TIME_INCR) {
                    this.compression = this.compression + "Incremental";
                } else if (nArray5[0] == HDF5Constants.H5D_ALLOC_TIME_LATE) {
                    this.compression = this.compression + "Late";
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        finally {
            try {
                H5.H5Pclose((int)n2);
            }
            catch (Exception exception) {}
            this.close(n);
        }
        return this.attributeList;
    }

    public void writeMetadata(Object object) throws Exception {
        if (!(object instanceof Attribute)) {
            return;
        }
        boolean bl = false;
        Attribute attribute = (Attribute)object;
        String string = attribute.getName();
        if (this.attributeList == null) {
            this.getMetadata();
        } else {
            bl = this.attributeList.contains(attribute);
        }
        this.getFileFormat().writeAttribute((HObject)this, attribute, bl);
        if (!bl) {
            this.attributeList.add(attribute);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMetadata(Object object) throws HDF5Exception {
        if (!(object instanceof Attribute)) {
            return;
        }
        Attribute attribute = (Attribute)object;
        int n = this.open();
        try {
            H5.H5Adelete((int)n, (String)attribute.getName());
            List list = this.getMetadata();
            list.remove(attribute);
        }
        finally {
            this.close(n);
        }
    }

    public int open() {
        int n = -1;
        try {
            n = H5.H5Dopen((int)this.getFID(), (String)(this.getPath() + this.getName()));
        }
        catch (HDF5Exception hDF5Exception) {
            n = -1;
        }
        return n;
    }

    public void close(int n) {
        try {
            H5.H5Fflush((int)n, (int)HDF5Constants.H5F_SCOPE_LOCAL);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            H5.H5Dclose((int)n);
        }
        catch (HDF5Exception hDF5Exception) {
            // empty catch block
        }
    }

    public byte[][] getPalette() {
        if (this.palette == null) {
            this.palette = this.readPalette(0);
        }
        return this.palette;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[][] readPalette(int n) {
        byte[][] byArray = null;
        byte[] byArray2 = this.getPaletteRefs();
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        if (byArray2 == null) {
            return null;
        }
        byte[] byArray3 = null;
        byte[] byArray4 = new byte[8];
        try {
            System.arraycopy(byArray2, n * 8, byArray4, 0, 8);
        }
        catch (Throwable throwable) {
            return null;
        }
        try {
            n2 = this.open();
            n3 = H5.H5Rdereference((int)this.getFID(), (int)HDF5Constants.H5R_OBJECT, (byte[])byArray4);
            n4 = H5.H5Dget_type((int)n3);
            if (H5.H5Dget_storage_size((int)n3) <= 768L) {
                byArray3 = new byte[768];
                H5.H5Dread((int)n3, (int)n4, (int)HDF5Constants.H5S_ALL, (int)HDF5Constants.H5S_ALL, (int)HDF5Constants.H5P_DEFAULT, (byte[])byArray3);
            }
        }
        catch (HDF5Exception hDF5Exception) {
            byArray3 = null;
        }
        finally {
            try {
                H5.H5Tclose((int)n4);
            }
            catch (HDF5Exception hDF5Exception) {}
            this.close(n3);
            this.close(n2);
        }
        if (byArray3 != null) {
            byArray = new byte[3][256];
            for (int i = 0; i < 256; ++i) {
                byArray[0][i] = byArray3[i * 3];
                byArray[1][i] = byArray3[i * 3 + 1];
                byArray[2][i] = byArray3[i * 3 + 2];
            }
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static H5ScalarDS create(String string, Group group, Datatype datatype, long[] lArray, long[] lArray2, long[] lArray3, int n, Object object) throws Exception {
        int n2;
        int n3;
        H5ScalarDS h5ScalarDS = null;
        String string2 = null;
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        if (group == null || string == null || lArray == null || n > 0 && lArray3 == null) {
            return null;
        }
        H5File h5File = (H5File)group.getFileFormat();
        if (h5File == null) {
            return null;
        }
        String string3 = "/";
        if (!group.isRoot()) {
            string3 = group.getPath() + group.getName() + "/";
            if (string.endsWith("/")) {
                string = string.substring(0, string.length() - 1);
            }
            if ((n3 = string.lastIndexOf("/")) >= 0) {
                string = string.substring(n3 + 1);
            }
        }
        string2 = string3 + string;
        n3 = 0;
        if (lArray2 != null) {
            for (n2 = 0; n2 < lArray2.length; ++n2) {
                if (lArray2[n2] == 0L) {
                    lArray2[n2] = lArray[n2];
                } else if (lArray2[n2] < 0L) {
                    lArray2[n2] = HDF5Constants.H5S_UNLIMITED;
                }
                if (lArray2[n2] == lArray[n2]) continue;
                n3 = 1;
            }
        }
        if (lArray3 == null && n3 != 0) {
            lArray3 = lArray;
        }
        n2 = lArray.length;
        try {
            n5 = datatype.toNative();
            n6 = H5.H5Screate_simple((int)n2, (long[])lArray, (long[])lArray2);
            n7 = HDF5Constants.H5P_DEFAULT;
            if (lArray3 != null) {
                n7 = H5.H5Pcreate((int)HDF5Constants.H5P_DATASET_CREATE);
                H5.H5Pset_layout((int)n7, (int)HDF5Constants.H5D_CHUNKED);
                H5.H5Pset_chunk((int)n7, (int)n2, (long[])lArray3);
            }
            if (n > 0) {
                H5.H5Pset_deflate((int)n7, (int)n);
            }
            int n8 = h5File.open();
            n4 = H5.H5Dcreate((int)n8, (String)string2, (int)n5, (int)n6, (int)n7);
            byte[] byArray = H5.H5Rcreate((int)n8, (String)string2, (int)HDF5Constants.H5R_OBJECT, (int)-1);
            long l = HDFNativeData.byteToLong((byte[])byArray, (int)0);
            long[] lArray4 = new long[]{l};
            h5ScalarDS = new H5ScalarDS(h5File, string, string3, lArray4);
        }
        finally {
            try {
                H5.H5Pclose((int)n7);
            }
            catch (HDF5Exception hDF5Exception) {}
            try {
                H5.H5Sclose((int)n6);
            }
            catch (HDF5Exception hDF5Exception) {}
            try {
                H5.H5Tclose((int)n5);
            }
            catch (HDF5Exception hDF5Exception) {}
            try {
                H5.H5Dclose((int)n4);
            }
            catch (HDF5Exception hDF5Exception) {}
        }
        if (h5ScalarDS != null) {
            group.addToMemberList((HObject)h5ScalarDS);
            if (object != null) {
                h5ScalarDS.write(object);
            }
        }
        return h5ScalarDS;
    }

    public byte[] getPaletteRefs() {
        if (this.rank <= 0) {
            this.init();
        }
        return this.paletteRefs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getPaletteRefs(int n) {
        int n2 = -1;
        int n3 = -1;
        int n4 = 0;
        int n5 = 0;
        int n6 = -1;
        byte[] byArray = null;
        try {
            n2 = H5.H5Aopen_name((int)n, (String)"PALETTE");
            n3 = H5.H5Aget_space((int)n2);
            n5 = H5.H5Sget_simple_extent_ndims((int)n3);
            n4 = 1;
            if (n5 > 0) {
                long[] lArray = new long[n5];
                H5.H5Sget_simple_extent_dims((int)n3, (long[])lArray, null);
                for (int i = 0; i < n5; ++i) {
                    n4 *= (int)lArray[i];
                }
            }
            byArray = new byte[n4 * 8];
            n6 = H5.H5Aget_type((int)n2);
            H5.H5Aread((int)n2, (int)n6, (byte[])byArray);
        }
        catch (HDF5Exception hDF5Exception) {
            byArray = null;
        }
        finally {
            try {
                H5.H5Tclose((int)n6);
            }
            catch (HDF5Exception hDF5Exception) {}
            try {
                H5.H5Sclose((int)n3);
            }
            catch (HDF5Exception hDF5Exception) {}
            try {
                H5.H5Aclose((int)n2);
            }
            catch (HDF5Exception hDF5Exception) {}
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Datatype getDatatype() {
        if (this.datatype == null) {
            int n = -1;
            int n2 = -1;
            n = this.open();
            try {
                n2 = H5.H5Dget_type((int)n);
                if (!this.isNativeDatatype) {
                    int n3 = -1;
                    try {
                        n3 = n2;
                        n2 = H5.H5Tget_native_type((int)n3);
                    }
                    finally {
                        try {
                            H5.H5Tclose((int)n3);
                        }
                        catch (Exception exception) {}
                    }
                }
                this.datatype = new H5Datatype(n2);
            }
            catch (Exception exception) {
            }
            finally {
                try {
                    H5.H5Tclose((int)n2);
                }
                catch (HDF5Exception hDF5Exception) {}
                try {
                    H5.H5Dclose((int)n);
                }
                catch (HDF5Exception hDF5Exception) {}
            }
        }
        return this.datatype;
    }

    public void setName(String string) throws Exception {
        String string2 = this.getPath() + this.getName();
        String string3 = this.getPath() + string;
        string2 = string2.replaceAll("//", "/");
        string3 = string3.replaceAll("//", "/");
        if (string2.equals("/")) {
            throw new HDF5Exception("Can't rename the root group.");
        }
        if (string2.equals(string3)) {
            throw new HDF5Exception("The new name is the same as the current name.");
        }
        H5.H5Gmove((int)this.getFID(), (String)string2, (String)string3);
        super.setName(string);
    }
}

