<#-- Declare variables -->
<#-- @ftlvariable name="img_logo" type="java.lang.String" -->
<#-- @ftlvariable name="favicon" type="java.lang.String" -->
<#-- @ftlvariable name="report_date" type="java.util.Date" -->
<#-- @ftlvariable name="group" type="java.lang.String" -->
<#-- @ftlvariable name="headers" type="java.util.List<se.prediktera.breeze.frontend.common.report.FreemarkerReportCreator.TableHeader>" -->
<#-- @ftlvariable name="rows" type="java.util.List<java.util.List<se.prediktera.breeze.frontend.common.report.FreemarkerReportCreator.TableCell>>" -->
<#-- @ftlvariable name="workflow" type="java.lang.String" -->
<#-- @ftlvariable name="disableJavaScript" type="java.lang.Boolean" -->
<#-- @ftlvariable name="legendColorScale" type="java.lang.String[]" -->
<#-- @ftlvariable name="availableCategories" type="java.util.List<se.prediktera.breeze.frontend.common.report.FreemarkerReportCreator.CategoryHolder>" -->

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Breeze Report - ${workflow}</title>
    <link rel="icon" type="image/png" href="${favicon}"/>
    <style>
        <#include "assets/bootstrap.min.css" parse=false>
        <#include "assets/style.css" parse=false>
        .gradient-legend-color-scale {
            min-width: 40px;
            background: linear-gradient(<#list legendColorScale?reverse as color>${color}<#sep>, </#sep></#list>);
        }

        <#--noinspection CssUnusedSymbol-->
        .gradient-legend-color-scale-vertical-to-black {
            min-width: 100px;
            background: linear-gradient(to bottom, transparent, black), linear-gradient(to right, <#list legendColorScale?reverse as color>${color}<#sep>, </#sep></#list>);
        }
    </style>
</head>
<body>
<div class="container mt-5">
    <div class="row align-items-center mb-4">
        <div class="col-md-8">
            <h1>${workflow}
                <#if group?has_content>
                    - ${group}
                </#if>
            </h1>
            <small class="text-muted">Created ${report_date}</small>
        </div>
        <div class="col-md-4 mr-3 d-flex justify-content-end">
            <img src="${img_logo}" alt="Company Logo">
        </div>
    </div>

    <#if availableCategories??>
        <div class="d-flex pb-2">
            <#assign holder_index = 0 />
            <#list availableCategories as holder>
                <div class="accordion me-3" id="accordion${holder_index}">
                    <div class="accordion-item">
                        <h2 class="accordion-header" id="heading${holder_index}">
                            <button class="accordion-button" type="button" data-bs-toggle="collapse"
                                    data-bs-target="#collapse${holder_index}" aria-expanded="true"
                                    aria-controls="collapse${holder_index}">
                                ${holder.Name()} &nbsp;
                            </button>
                        </h2>
                        <div id="collapse${holder_index}" class="accordion-collapse collapse show"
                             aria-labelledby="heading${holder_index}" data-bs-parent="#accordion${holder_index}">
                            <div class="accordion-body">
                                <ol class="list-group">
                                    <#list holder.Categories() as cat>
                                        <li class="list-group-item d-flex justify-content-between align-items-start">
                                            <div class="ms-2 me-auto pe-2">
                                                <div class="fw-bold">${cat.getLeft()}</div>
                                            </div>
                                            <div class="d-inline-block align-middle category-box me-2"
                                                 style="background-color: ${cat.getRight()};"></div>
                                        </li>
                                    </#list>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>
                <#assign holder_index++ />
            </#list>
        </div>
    </#if>


    <table id="sortable-table" class="table table-striped table-hover table-bordered">
        <thead>
        <tr>
            <#assign makeFirstSortableHeaderDefault = false />
            <#assign counter = 0 />
            <#list headers as header>
            <#-- Add chveron to first sortable header -->
                <#if header.sortable>
                    <#assign dataDefaultLabel = (!makeFirstSortableHeaderDefault)?then("data-sort-default","") />
                    <#assign makeFirstSortableHeaderDefault = true />
                </#if>
                <th ${dataDefaultLabel} scope="col"
                                        data-sortable="${header.sortable?c}"
                                        colspan="${header.colspan}"
                                        data-sort-column-key="c-${counter}"
                                        class="header-${header.type} table-header-text">
                    ${header.name}
                </th>
                <#assign counter += header.colspan />
            </#list>
        </tr>
        </thead>
        <tbody>
        <#list rows as row>
            <#assign counter = 0 />
            <tr>
                <#list row as cell>
                    <#assign willRenderThumbnail = cell.type == "thumbnail" || cell.type?starts_with("legend") />
                    <#assign hasCellValue = !cell.isMissingValue() && cell.value?has_content && cell.value != "data:image/png;base64," && cell.value != "--MISSING--" />
                    <#assign shouldAlignWithBoxOrBar = cell.type == "descriptor" || cell.type == "category-factor"|| cell.type == "percent" />

                    <#assign centerClasses = (willRenderThumbnail || !hasCellValue || shouldAlignWithBoxOrBar )?then("text-center align-middle", "")>

                    <td data-sort="${cell.sortValue}" class="${centerClasses}"
                        data-sort-column-key="c-${counter}">
                        <#if hasCellValue>
                            <#if willRenderThumbnail>
                                <#assign imgContent = "<img src='${cell.value}' alt='Popover' class='popover-img' />" />
                                <#if cell.type?starts_with("legend")>
                                    <#assign gradient_css_class = (cell.type == "legend")?then("gradient-legend-color-scale", "gradient-legend-color-scale-vertical-to-black") />
                                    <#compress>
                                        <#assign legendContent>
                                            <div class='gradient-legend-container'>
                                                <div class='gradient-legend ${gradient_css_class} mx-2'>
                                                    <div class='gradient-legend-min'>${cell.min?string["0.##"]}</div>
                                                    <div class='gradient-legend-max'>${cell.max?string["0.##"]}</div>
                                                </div>
                                                <#if cell.hasXLabels()>
                                                    <div class='d-flex justify-content-between'>
                                                        <div>${cell.minWl?string["0.#"]}</div>
                                                        <div class='pt-3'>${cell.middleWl?string["0.#"]}</div>
                                                        <div>${cell.maxWl?string["0.#"]}</div>
                                                    </div>
                                                </#if>
                                            </div>
                                        </#assign>
                                        <#assign imgContent = "<div class='popover-legend'>" + imgContent + legendContent?replace("\n","") + "</div>" />
                                    </#compress>
                                </#if>
                                <img tabindex="0"
                                     src="${cell.value}"
                                     alt="Thumbnail"
                                     class="img-thumbnail img-thumbnail-fixed-height"
                                     data-bs-toggle="popover"
                                     data-bs-placement="right"
                                     data-bs-html="true"
                                     data-bs-trigger="focus"
                                     data-bs-content="${imgContent?replace('"','\'')}">
                            <#elseif cell.type == "descriptor" || cell.type == "category-factor">
                                <div class="d-flex align-items-center">
                                    <#if cell.color??>
                                        <div class="category-box" style="background-color: ${cell.color};"></div>
                                    </#if>
                                    <span class="descriptor-text">${cell.value}</span>
                                </div>
                            <#elseif cell.type == "percent">
                                <#assign numberValue = cell.value?replace("%", "")?replace("&nbsp;", "")?replace(" ", "")?trim?number>
                                <#assign numberValue = (numberValue < 0)?then(0, (numberValue > 100)?then(100, numberValue))>
                                <div class="progress position-relative" role="progressbar" aria-valuemin="0"
                                     aria-valuemax="100" style="height: 20px; min-width: 65px"
                                     aria-valuenow="${numberValue}">
                                    <div class="progress-bar light-green-progress" style="width: ${numberValue}%"></div>
                                    <div class="position-absolute w-100 h-100 d-flex align-items-center justify-content-center"
                                         style="font-size: 1rem;">
                                        <span>${cell.value}</span>
                                    </div>
                                </div>
                            <#else>
                                ${cell.value}
                            </#if>
                        <#else>
                            <span class="badge bg-warning" data-bs-toggle="tooltip" data-bs-placement="top"
                                  title="Apply changes or import missing variables">Missing</span>
                        </#if>
                    </td>
                    <#assign counter++ />
                </#list>
            </tr>
        </#list>
        </tbody>
    </table>
</div>
<#if !disableJavaScript>
    <script type="text/javascript">
        <#include "assets/tablesort.min.js" parse=false>
    </script>
    <script type="text/javascript">
        <#include "assets/tablesort.number.min.js" parse=false>
    </script>
    <script type="text/javascript">
        <#include "assets/bootstrap.bundle.min.js" parse=false>
    </script>
    <script>
        <#compress>
        document.addEventListener("DOMContentLoaded", function () {
            new Tablesort(document.getElementById("sortable-table"));
            const popoverTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="popover"]'))
            popoverTriggerList.map(function (popoverTriggerEl) {
                <#--noinspection JSUnresolvedReference-->
                return new bootstrap.Popover(popoverTriggerEl, {trigger: 'focus'});
            });
        });
        </#compress>
    </script>
</#if>
</body>
</html>
